/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugin.rqm

public class RQMHelper {

    final static String EXIT_ON_COMPLETE = "-exitOnComplete=true";
    final static String PRINT_RESULT_URL = "-printResultUrl=true";

    /**
     * @param arguments String containing RQM's additional arguments
     * @return String containing '-exitOnComplete=true' or -'printResultUrl=true' if missing
     */
    public static String setRequiredArguments(String arguments) {
        String result = arguments;

        // Add '-exitOnComplete=true' if missing
        if (!arguments.split(" ").contains(EXIT_ON_COMPLETE)){
            if (arguments) {
                result += " " + EXIT_ON_COMPLETE;
            } else {
                result = EXIT_ON_COMPLETE;
            }
        }

        // Add '-printResultUrl=true' if missing
        if (!arguments.split(" ").contains(PRINT_RESULT_URL)){
            result += " " + PRINT_RESULT_URL;
        }
        return result;
    }

    /**
     * @param filepath  The file path provided by the user.
     * @param jarName   The name of the RQM Jar to find.
     * @return          The canonical file path of the RQM jar.
     */
    private static String findRQMJar(String filepath, String jarName) {
        // Find RQMJar as full path or within the given folder
        File rqmFile = new File(filepath)
        if (!rqmFile.isFile()) {
            filepath = rqmFile.getCanonicalPath() + File.separator + jarName
            rqmFile = new File(filepath)
            if (!rqmFile.isFile()){
                throw new FileNotFoundException("[Error] Cannot find ${jarName} inside the given directory: '${rqmFile.getCanonicalPath()}'");
            }
        }
        if (!rqmFile.getCanonicalPath().endsWith(jarName)) {
            throw new FileNotFoundException("[Error] Invalid ${jarName} path: '${rqmFile.getCanonicalPath()}'");
        }
        println "${jarName} Path: " + rqmFile.getCanonicalPath();
        return filepath
    }

    /**
     * @param resultURL The full String ResultURL
     * @return          The Execution Result's ID
     */
     // Grabs the ID outlined here: https://jazz.net/wiki/bin/view/Main/RqmApi#id
    private static String parseResultURLID(String resultURL) {
        try {
            URL url = new URI(resultURL).toURL()
            resultURL = url.toString()
        }
        catch (URISyntaxException ex) {
            throw new URISyntaxException("[Error] Invalid ResultURL '${resultURL}' provided.")
        }
        String result = ""
        String temp = resultURL.substring(resultURL.lastIndexOf("/")+1)
        // If a ':' character doesn't exist, the full string is returned
        result = temp.substring(temp.lastIndexOf(":")+1)
        return result
    }
}
