/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class ConcurrentHashSet<E>
extends AbstractSet<E> {
    private final ConcurrentHashMap<E, Boolean> map;
    private final Set<E> set;

    public static <E> ConcurrentHashSet<E> createWithConcurrency(int concurrency) {
        return new ConcurrentHashSet(new ConcurrentHashMap(16, 0.75f, concurrency));
    }

    public ConcurrentHashSet() {
        this(new ConcurrentHashMap());
    }

    public ConcurrentHashSet(ConcurrentHashMap<E, Boolean> map) {
        this.map = map;
        this.set = map.keySet();
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, Boolean.TRUE) == null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        return o == this || ((Object)this.set).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.set).hashCode();
    }

    @Override
    public String toString() {
        return this.set.toString();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }
}

