/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.digest;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import java.security.MessageDigest;
import java.util.zip.Checksum;

@BridgeMethodsAdded
public class ChecksumDigest
extends MessageDigest {
    private final Checksum checksum;

    protected ChecksumDigest(String algorithm, Checksum checksum) {
        super(algorithm);
        Check.nonBlank(algorithm, "algorithm name");
        Check.nonNull(checksum, "checksum");
        this.checksum = checksum;
    }

    protected byte[] engineDigest() {
        long l = this.checksum.getValue();
        return this.longToByteArray(l);
    }

    protected void engineReset() {
        this.checksum.reset();
    }

    protected void engineUpdate(byte input) {
        this.checksum.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.checksum.update(input, offset, len);
    }

    public long digestLong() {
        return this.checksum.getValue();
    }

    private byte[] longToByteArray(long l) {
        byte[] bytes = new byte[]{this.getByte(l, 3), this.getByte(l, 2), this.getByte(l, 1), this.getByte(l, 0)};
        return bytes;
    }

    private byte getByte(long l, int byteOffset) {
        int bitOffset = byteOffset * 8;
        return (byte)((l & (long)(255 << bitOffset)) >> bitOffset);
    }
}

