/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.windows;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class CmdUtil {
    private static final String WS = " \t";
    private static final String CMDWS = ";=,";
    private static final String SPECIAL = " \t;=,\"";
    private static final String CMDSPECIAL = "()%!^<>&|";

    public static String buildCommand(List<String> command) {
        return CmdUtil.buildCommand(false, command);
    }

    public static String buildCommand(boolean quoteCmdChars, List<String> command) {
        return CmdUtil.buildCommand(quoteCmdChars, command.toArray(new String[command.size()]));
    }

    public static String buildCommand(String ... command) {
        return CmdUtil.buildCommand(false, command);
    }

    public static String buildCommand(boolean quoteCmdChars, String ... command) {
        String result = "";
        if (command.length == 0) {
            throw new IllegalArgumentException("command is empty");
        }
        command = (String[])command.clone();
        for (int i = 0; i < command.length; ++i) {
            if (quoteCmdChars) {
                command[i] = CmdUtil.quoteCmd(command[i]);
            }
            command[i] = CmdUtil.quoteArg(command[i]);
        }
        result = CmdUtil.join(command);
        if (command.length > 1) {
            result = '\"' + result + '\"';
        }
        return result;
    }

    private static String quoteArg(String arg) {
        String result;
        if (arg.length() == 0) {
            result = "\"\"";
        } else if (!CmdUtil.contains(arg, SPECIAL)) {
            result = arg;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            char[] cs = arg.toCharArray();
            int i = 0;
            while (true) {
                int j;
                int nbs = 0;
                while (i < cs.length && cs[i] == '\\') {
                    ++i;
                    ++nbs;
                }
                if (i == cs.length) {
                    for (j = 0; j < nbs; ++j) {
                        sb.append("\\\\");
                    }
                    break;
                }
                if (cs[i] == '\"') {
                    for (j = 0; j < nbs; ++j) {
                        sb.append("\\\\");
                    }
                    sb.append('\\');
                    sb.append(cs[i]);
                } else {
                    for (j = 0; j < nbs; ++j) {
                        sb.append('\\');
                    }
                    sb.append(cs[i]);
                }
                ++i;
            }
            sb.append('\"');
            result = sb.toString();
        }
        return result;
    }

    private static String quoteCmd(String arg) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (CMDSPECIAL.indexOf(c) < 0) {
                sb.append(c);
                continue;
            }
            sb.append("^");
            sb.append(c);
        }
        return sb.toString();
    }

    private static String join(String ... xs) {
        StringBuilder sb = new StringBuilder();
        sb.append(xs[0]);
        for (int i = 1; i < xs.length; ++i) {
            sb.append(' ').append(xs[i]);
        }
        return sb.toString();
    }

    private static boolean contains(String s, String chars) {
        char[] cs;
        boolean result = false;
        for (char c : cs = chars.toCharArray()) {
            if (s.indexOf(c) == -1) continue;
            result = true;
            break;
        }
        return result;
    }

    private CmdUtil() {
        throw new UnsupportedOperationException();
    }
}

