/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.client.ExecutionToolConnectionHelper;
import com.ibm.rqm.executiontool.internal.CommandLineArgumentProcessor;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.util.ExecutionLogger;
import com.ibm.rqm.integration.client.clientlib.RQMConnectionHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExecutionCommandProcessor {
    private static final String TERSERVICEPATH = "/service/com.ibm.rqm.execution.common.service.rest.ITestcaseExecutionRecordRestService/executeDTO";
    private static final String TSERSERVICEPATH = "/service/com.ibm.rqm.execution.common.service.rest.ITestSuiteExecutionRecordRestService/execute";
    private static final String INTEGRATIONPATH = "/service/com.ibm.rqm.integration.service.IIntegrationService/resources/";
    private static final String PROJECTSPATH = "/service/com.ibm.rqm.integration.service.IIntegrationService/projects/";
    private static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";
    private static final String ALM_QM_NAMESPACE = "http://jazz.net/xmlns/alm/qm/v0.1/";
    private static final String RESULT_URL_LOG_PREFIX = "result url: ";
    private String projectName;
    private String projectAlias;
    private String publicUri;
    private String user;
    private String password;
    private String proxy;
    private String proxyPort;
    private String proxyPassword;
    private String proxyUser;
    private long progressCycle = 10000L;
    private boolean isVerbose = false;
    private Map<String, CommandLineArgumentProcessor.CmdLineArg> cmdArgs;

    public ExecutionCommandProcessor(Map<String, CommandLineArgumentProcessor.CmdLineArg> map) {
        this.cmdArgs = map;
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PROJECTNAME.name()) != null) {
            this.projectName = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROJECTNAME.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PROJECTALIAS.name()) != null) {
            this.projectAlias = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROJECTALIAS.name()).getVal();
        }
        this.publicUri = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PUBLICURI.name()).getVal();
        this.user = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.USER.name()).getVal();
        this.password = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PASSWORD.name()).getVal();
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROGRESSCHECKCYCLE.name());
        if (cmdLineArg != null && cmdLineArg.getVal() != null) {
            this.progressCycle = Long.valueOf(cmdLineArg.getVal());
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.VERBOSE.name()) != null) {
            this.isVerbose = true;
        }
    }

    public ExecResult processCommands() throws RQMExecutionToolException {
        this.login(this.publicUri, this.user, this.password, this.proxy, this.proxyPort, this.proxyUser, this.proxyPassword);
        if (this.projectAlias == null) {
            this.projectAlias = this.getProjectAliasByName(this.projectName);
            if (this.projectAlias == null) {
                ExecutionLogger.logError("Unable to find project: " + this.projectName + ".  Verify the project exist and user running the Execution Utility is a member of the project.");
                return new ExecResult(ExecResult.ExitCode.PROJECT_NOT_FOUND, "");
            }
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.TCERID.name()) != null) {
            return this.processTestCaseExecution();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.TSERID.name()) != null) {
            return this.processTestSuiteExecution();
        }
        throw new IllegalArgumentException("Neither terId or tserId provided.");
    }

    private ExecResult processTestCaseExecution() throws RQMExecutionToolException {
        Object object;
        Object object2;
        ExecutionLogger.logInfo("Starting TestCase Execution");
        String string = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.TCERID.name()).getVal();
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SCRIPTID.name());
        String string2 = null;
        if (cmdLineArg != null) {
            string2 = cmdLineArg.getVal();
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg2 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.ADAPTERID.name());
        String string3 = null;
        if (cmdLineArg2 != null) {
            string3 = cmdLineArg2.getVal();
        }
        String string4 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.RESULTSTATE.name());
        if (cmdLineArg3 != null) {
            string4 = cmdLineArg3.getVal();
        }
        boolean bl = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg4 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.name());
        if (cmdLineArg4 != null) {
            bl = Boolean.valueOf(cmdLineArg4.getVal());
        }
        boolean bl2 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg5 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.name());
        if (cmdLineArg5 != null) {
            bl2 = Boolean.valueOf(cmdLineArg5.getVal());
        }
        String string5 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg6 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.VARIABLES.name());
        if (cmdLineArg6 != null) {
            string5 = this.toVariableJson(cmdLineArg6.getVal());
        }
        ArrayList<ExecutionToolConnectionHelper.PostParams> arrayList = new ArrayList<ExecutionToolConnectionHelper.PostParams>();
        ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
        postParams.paramName = "ewiId";
        postParams.paramValue = string;
        arrayList.add(postParams);
        ExecutionToolConnectionHelper.PostParams postParams2 = new ExecutionToolConnectionHelper.PostParams();
        postParams2.paramName = "projectAreaAlias";
        postParams2.paramValue = this.projectAlias;
        arrayList.add(postParams2);
        if (string2 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "scriptId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string2;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string3 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "adapterId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string3;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string4 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "state";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string4;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
            if (bl2) {
                object = new ExecutionToolConnectionHelper.PostParams();
                ((ExecutionToolConnectionHelper.PostParams)object).paramName = "resolveResult";
                ((ExecutionToolConnectionHelper.PostParams)object).paramValue = "true";
                arrayList.add((ExecutionToolConnectionHelper.PostParams)object);
            }
        }
        if (string5 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "variableJson";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string5;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        object2 = null;
        object = this.publicUri + TERSERVICEPATH;
        try {
            object2 = ExecutionToolConnectionHelper.postToServer(new URL((String)object), arrayList);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ". Please verify that the adapter being used is running and the values for parameters tcerId, scriptId, adapterId are valid and exist.");
            if (this.isVerbose) {
                ExecutionLogger.logError(protocolException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(malformedURLException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(iOException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        int n = (Integer)object2.get("rqm_responseCode");
        String string6 = "";
        if (n == 200 || n == 201) {
            if (string4 != null) {
                String string7;
                int n2;
                if (bl2 && (n2 = (string7 = (String)object2.get("rqm_responseContent")).indexOf("<result>")) > -1) {
                    int n3 = string7.indexOf("<id>", n2) + "<id>".length();
                    String string8 = string7.substring(n3, string7.indexOf("</id>", n3));
                    string6 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/executionresult/urn:com.ibm.rqm:executionresult:" + string8;
                    ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string6);
                    string6 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/executionresult/urn:com.ibm.rqm:executionresult:" + string8;
                    ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string6);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_FINISHED, string6);
            }
            ExecutionLogger.logInfo("Execution started");
            String string9 = (String)object2.get("rqm_responseContent");
            int n4 = string9.indexOf("<requestId>") + "<requestId>".length();
            String string10 = string9.substring(n4, string9.indexOf("</requestId>", n4));
            if (string10 != null && string10.trim().length() > 0) {
                int n5 = Integer.valueOf(string10.trim());
                ExecutionLogger.logInfo("Execution instance created on server with request Id " + string10);
                if (bl) {
                    URL uRL = null;
                    try {
                        uRL = new URL(this.publicUri + INTEGRATIONPATH + this.projectAlias + "/tasks/urn:com.ibm.rqm:tasks:" + n5);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ExecutionLogger.logError("Exception occurred while creating URL for request service: " + uRL == null ? "" : uRL.toString());
                        if (this.isVerbose) {
                            ExecutionLogger.logError(malformedURLException.getMessage());
                        }
                        return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                    }
                    while (true) {
                        String string11;
                        Map map;
                        try {
                            map = ExecutionToolConnectionHelper.getFromServer(uRL);
                        }
                        catch (ProtocolException protocolException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string10 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(protocolException.getMessage());
                            }
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                        }
                        catch (IOException iOException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string10 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(iOException.getMessage());
                            }
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                        }
                        n = (Integer)map.get("rqm_responseCode");
                        if ((n == 200 || n == 201) && (string11 = (String)map.get("rqm_responseMessage")) != null) {
                            int n6 = string11.indexOf("com.ibm.rqm.executionframework.common.requeststate.");
                            String string12 = string11.substring(n6 + "com.ibm.rqm.executionframework.common.requeststate.".length(), string11.indexOf("</", n6));
                            if (string12.equals("complete")) {
                                ExecutionLogger.logInfo("Execution completed");
                                return this.getResultState(string10, bl2);
                            }
                            if (string12.equals("nottaken")) {
                                ExecutionLogger.logInfo("Waiting to start Execution");
                            } else if (string12.equals("taken")) {
                                int n7 = string11.indexOf("progress>");
                                String string13 = string11.substring(n7 + "progress>".length(), string11.indexOf("</", n7));
                                ExecutionLogger.logInfo("Execution is in proress: " + string13 + "%");
                            } else if (string12.equals("cancelled")) {
                                ExecutionLogger.logInfo("Execution is cancelled");
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_CANCELLED, "");
                            }
                        }
                        try {
                            Thread.sleep(this.progressCycle);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (bl2) {
                    ExecutionLogger.logWarn(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.getArgName() + " argument is required to support " + CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.getArgName() + " option for test case execution.");
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, "");
            }
        }
        ExecutionLogger.logError("Execution request sent to server failed with response code :" + n);
        return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
    }

    private ExecResult processTestSuiteExecution() throws RQMExecutionToolException {
        Object object;
        Object object2;
        ExecutionLogger.logInfo("Starting TestSuite Execution");
        ArrayList<ExecutionToolConnectionHelper.PostParams> arrayList = new ArrayList<ExecutionToolConnectionHelper.PostParams>();
        ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
        postParams.paramName = "projectAreaAlias";
        postParams.paramValue = this.projectAlias;
        arrayList.add(postParams);
        String string = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.TSERID.name()).getVal();
        ExecutionToolConnectionHelper.PostParams postParams2 = new ExecutionToolConnectionHelper.PostParams();
        postParams2.paramName = "id";
        postParams2.paramValue = string;
        arrayList.add(postParams2);
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITESTEPSCRIPTIDS.name());
        String string2 = null;
        if (cmdLineArg != null) {
            string2 = cmdLineArg.getVal();
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg2 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITESTEPADAPTERIDS.name());
        String string3 = null;
        if (cmdLineArg2 != null) {
            string3 = cmdLineArg2.getVal();
        }
        String string4 = null;
        if (string2 != null || string3 != null) {
            string4 = this.toSuiteElementJson(string2, string3);
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "suiteElementsJsonString";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string4;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        object2 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.RESULTSTATE.name());
        if (cmdLineArg3 != null) {
            object2 = cmdLineArg3.getVal();
            ExecutionToolConnectionHelper.PostParams postParams3 = new ExecutionToolConnectionHelper.PostParams();
            postParams3.paramName = "state";
            postParams3.paramValue = object2;
            arrayList.add(postParams3);
        }
        boolean bl = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg4 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.name());
        if (cmdLineArg4 != null) {
            bl = Boolean.valueOf(cmdLineArg4.getVal());
        }
        boolean bl2 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg5 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.name());
        if (cmdLineArg5 != null) {
            bl2 = Boolean.valueOf(cmdLineArg5.getVal());
        }
        String string5 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg6 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.VARIABLES.name());
        if (cmdLineArg6 != null) {
            string5 = this.toVariableJson(cmdLineArg6.getVal());
            ExecutionToolConnectionHelper.PostParams postParams4 = new ExecutionToolConnectionHelper.PostParams();
            postParams4.paramName = "suiteVariableJson";
            postParams4.paramValue = string5;
            arrayList.add(postParams4);
        }
        boolean bl3 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg7 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PARALLELEXECUTION.name());
        if (cmdLineArg7 != null) {
            bl3 = Boolean.valueOf(cmdLineArg7.getVal());
            ExecutionToolConnectionHelper.PostParams postParams5 = new ExecutionToolConnectionHelper.PostParams();
            postParams5.paramName = "isSerialExecution";
            postParams5.paramValue = String.valueOf(!bl3);
            arrayList.add(postParams5);
        }
        boolean bl4 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg8 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.HALTONFAILURE.name());
        if (cmdLineArg8 != null) {
            bl4 = Boolean.valueOf(cmdLineArg8.getVal());
            object = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object).paramName = "haltOnFailure";
            ((ExecutionToolConnectionHelper.PostParams)object).paramValue = String.valueOf(bl4);
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object);
        }
        object = this.publicUri + TSERSERVICEPATH;
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.postToServer(new URL((String)object), arrayList);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ". Please verify that the adapter being used is running and the values for parameters tserId, suiteStepScriptIds, suiteStepAdapterIds are valid and exist.");
            if (this.isVerbose) {
                ExecutionLogger.logError(protocolException.getMessage() + protocolException.toString());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(malformedURLException.getMessage() + malformedURLException.toString());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(iOException.getMessage() + iOException.toString());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        int n = (Integer)map.get("rqm_responseCode");
        if (n == 200 || n == 201) {
            int n2;
            String string6 = null;
            String string7 = (String)map.get("rqm_responseContent");
            String string8 = string7.substring(n2 = string7.indexOf("<id>") + "<id>".length(), string7.indexOf("</id>", n2));
            if (string8 != null && string8.trim().length() > 0) {
                int n3 = Integer.valueOf(string8.trim());
                ExecutionLogger.logInfo("Execution instance created on server with Test Suite Log Id " + string8);
                string6 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/testsuitelog/urn:com.ibm.rqm:testsuitelog:" + n3;
                if (bl2) {
                    ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string6);
                }
            }
            if (object2 != null) {
                return new ExecResult(ExecResult.ExitCode.EXECUTION_FINISHED, string6);
            }
            ExecutionLogger.logInfo("Testsuite Execution started");
            if (string6 != null) {
                if (bl) {
                    String string9 = string6 + "?fields=testsuitelog/(state)";
                    URL uRL = null;
                    try {
                        uRL = new URL(string9);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ExecutionLogger.logError("Exception occurred while creating URL for Testsuite log: " + uRL == null ? "" : uRL.toString());
                        if (this.isVerbose) {
                            ExecutionLogger.logError(malformedURLException.getMessage());
                        }
                        return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, string6);
                    }
                    while (true) {
                        String string10;
                        Map map2 = null;
                        try {
                            map2 = ExecutionToolConnectionHelper.getFromServer(uRL);
                        }
                        catch (ProtocolException protocolException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for Testsuite Log:" + string8 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(protocolException.getMessage());
                            }
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, string6);
                        }
                        catch (IOException iOException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for Testsuite Log:" + string8 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(iOException.getMessage());
                            }
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, string6);
                        }
                        n = (Integer)map2.get("rqm_responseCode");
                        if (n == 200 && (string10 = (String)map2.get("rqm_responseMessage")) != null) {
                            int n4 = string10.indexOf("com.ibm.rqm.execution.common.state.");
                            String string11 = string10.substring(n4 + "com.ibm.rqm.execution.common.state.".length(), string10.indexOf("</", n4));
                            if (string11.equals("inprogress")) {
                                ExecutionLogger.logInfo("Execution is in proress: ");
                            } else {
                                ExecutionLogger.logInfo("Test suite execution completed with status " + string11);
                                if (string11.equals("passed")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PASSED, string6);
                                }
                                if (string11.equals("failed")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_FAILED, string6);
                                }
                                if (string11.equals("blocked")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_BLOCKED, string6);
                                }
                                if (string11.equals("error")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string6);
                                }
                                if (string11.equals("inconclusive")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCONCLUSIVE, string6);
                                }
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_UNKNOWN, string6);
                            }
                        }
                        try {
                            Thread.sleep(this.progressCycle);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, string6);
            }
        }
        ExecutionLogger.logError("Execution request sent to server failed with response code :" + n);
        return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
    }

    private String toSuiteElementJson(String string, String string2) {
        String[] stringArray = string != null ? string.split(",") : null;
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.max(stringArray != null ? stringArray.length : 0, stringArray2 != null ? stringArray2.length : 0);
        stringBuffer.append("[");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{\"index\":");
            stringBuffer.append(i);
            if (stringArray != null && stringArray.length >= i + 1 && stringArray[i] != null && stringArray[i].trim().length() > 0) {
                stringBuffer.append(",\"testScriptId\":\"");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\"");
            }
            if (stringArray2 != null && stringArray2.length >= i + 1 && stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                stringBuffer.append(",\"adapterId\":\"");
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append("\"");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void login(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws RQMExecutionToolException {
        try {
            HostnameVerifier hostnameVerifier = RQMConnectionHelper.getHostnameVerifier();
            SSLContext sSLContext = RQMConnectionHelper.getTrustingSSLContext();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            ExecutionLogger.logInfo("Successfully created an HTTP client");
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Failed to create an HTTP client" + exception.getMessage());
            throw new RQMExecutionToolException(ExecResult.ExitCode.CONNECTIONERROR, "Failed to create an HTTP client", exception);
        }
        try {
            ExecutionToolConnectionHelper.login(new URL(string), string2, string3, string4, string5, string6, string7);
            ExecutionLogger.logInfo("Connection to RQM Server is established");
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.LOGIN_ERROR, "Failed to connect to RQM Server", exception);
        }
    }

    public String toVariableJson(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{\"name\":\"");
            stringBuffer.append(stringArray2[0]);
            stringBuffer.append("\"");
            if (stringArray2.length == 2) {
                stringBuffer.append(",\"value\":\"");
                stringBuffer.append(stringArray2[1]);
                stringBuffer.append("\"");
            }
            stringBuffer.append("}");
            bl = false;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private ExecResult getResultState(String string, boolean bl) throws RQMExecutionToolException {
        String string2;
        URL uRL = null;
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + this.projectAlias + "/tasks/urn:com.ibm.rqm:tasks:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            throw new RQMExecutionToolException(ExecResult.ExitCode.EXECUTION_COMPLETED, (Throwable)malformedURLException);
        }
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string + ". " + protocolException.getMessage());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string + ". " + iOException.getMessage());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
        }
        Integer n = (Integer)map.get("rqm_responseCode");
        if ((n == 200 || n == 201) && (string2 = (String)map.get("rqm_responseMessage")) != null) {
            int n2 = string2.indexOf("executionresult href=");
            if (n2 == -1) {
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
            }
            String string3 = string2.substring(n2 + "executionresult href=\"".length(), string2.indexOf("\"/>", n2));
            URL uRL2 = null;
            try {
                uRL2 = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new RQMExecutionToolException(ExecResult.ExitCode.EXECUTION_COMPLETED, (Throwable)malformedURLException);
            }
            if (bl) {
                ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string3);
            }
            try {
                map = ExecutionToolConnectionHelper.getFromServer(uRL2);
            }
            catch (ProtocolException protocolException) {
                ExecutionLogger.logError("Exception occurred while checking execution status for result:" + uRL2 + ". " + protocolException.getMessage());
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, string3);
            }
            catch (IOException iOException) {
                ExecutionLogger.logError("Exception occurred while checking execution status for result:" + uRL2 + ". " + iOException.getMessage());
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, string3);
            }
            n = (Integer)map.get("rqm_responseCode");
            if ((n == 200 || n == 201) && (string2 = (String)map.get("rqm_responseMessage")) != null) {
                n2 = string2.indexOf("com.ibm.rqm.execution.common.state.");
                String string4 = string2.substring(n2 + "com.ibm.rqm.execution.common.state.".length(), string2.indexOf("</", n2));
                if (string4.equals("passed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PASSED, string3);
                }
                if (string4.equals("failed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_FAILED, string3);
                }
                if (string4.equals("blocked")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_BLOCKED, string3);
                }
                if (string4.equals("error")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string3);
                }
                if (string4.equals("inconclusive")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCONCLUSIVE, string3);
                }
                if (string4.equals("incomplete")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCOMPLETE, string3);
                }
                if (string4.equals("perm_failed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PERM_FAILED, string3);
                }
                if (string4.equals("deferred")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_DEFERRED, string3);
                }
                if (string4.equals("part_blocked")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PARBLOCKED, string3);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_UNKNOWN, string3);
            }
        }
        return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
    }

    private String getProjectAliasByName(String string) {
        URL uRL;
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(this.publicUri + PROJECTSPATH);
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while creating URL for Projects: " + malformedURLException.getMessage());
            return null;
        }
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Exception occurred while retrieving list of projects:" + exception.getMessage());
            return null;
        }
        int n = (Integer)map.get("rqm_responseCode");
        if (n == 200) {
            String string2 = (String)map.get("rqm_responseMessage");
            if (string2 != null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(string2.getBytes("utf-8")));
                    NodeList nodeList = document.getElementsByTagNameNS(ALM_QM_NAMESPACE, "project");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element = (Element)nodeList.item(i);
                        String string3 = element.getElementsByTagNameNS(DC_NAMESPACE, "title").item(0).getTextContent();
                        String string4 = element.getElementsByTagNameNS(ALM_QM_NAMESPACE, "alias").item(0).getTextContent();
                        if (!string.equals(string3)) continue;
                        return string4;
                    }
                }
                catch (Exception exception) {
                    ExecutionLogger.logError("Exception occurred while processing project data:" + exception.getMessage());
                    return null;
                }
            }
        } else {
            ExecutionLogger.logError("Unable to retreive project data from RQM server.  Response code: " + n);
        }
        return null;
    }
}

