/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.integration.client.clientlib;

import com.ibm.rqm.integration.client.clientlib.SSLContextUtil;
import com.ibm.rqm.integration.client.clientlib.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.CookieHandler;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class RQMConnectionHelperJetty {
    public static final String RQM_RESPONSE_CONTENT = "rqm_responseContent";
    public static final String RQM_RESPONSE_MESSAGE = "rqm_responseMessage";
    public static final String RQM_RESPONSE_CODE = "rqm_responseCode";

    public static void setRQMDefaultCookieHandler() {
        CookieHandler.setDefault(new CookieHandler(){
            private HashMap cookies = new HashMap();

            public Map get(URI uRI, Map map) {
                HashMap hashMap = new HashMap();
                if (this.cookies != null && this.cookies.containsKey(uRI.getHost())) {
                    List list = (List)this.cookies.get(uRI.getHost());
                    String string = list.toString();
                    StringBuffer stringBuffer = new StringBuffer();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (stringBuffer.length() > 1) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append((String)iterator.next());
                    }
                    ArrayList<String> arrayList = new ArrayList<String>(1);
                    arrayList.add(stringBuffer.toString());
                    hashMap.put("Cookie", arrayList);
                }
                return hashMap;
            }

            public void put(URI uRI, Map map) {
                if (map.containsKey("Set-Cookie")) {
                    this.cookies.put(uRI.getHost(), map.get("Set-Cookie"));
                }
            }
        });
    }

    public static SSLContext getTrustingSSLContext() {
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        };
        return SSLContextUtil.createSSLContext(x509TrustManager);
    }

    public static void login(URL uRL, String string, String string2) throws ProtocolException, IOException, URISyntaxException {
        StringBuffer stringBuffer = new StringBuffer(uRL.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(":");
        stringBuffer.append(uRL.getPort());
        String string3 = null;
        URL uRL2 = null;
        HttpsURLConnection httpsURLConnection = null;
        OutputStreamWriter outputStreamWriter = null;
        if (CookieHandler.getDefault().get(uRL.toURI(), null).size() < 1) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            stringBuffer2.append(URLUtil.getIntegrationServicePath(uRL));
            string3 = stringBuffer2.toString();
            uRL2 = new URL(string3);
            httpsURLConnection = (HttpsURLConnection)uRL2.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestMethod("GET");
            outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            outputStreamWriter.flush();
            Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.toString());
            stringBuffer3.append("/jazz/j_security_check");
            string3 = stringBuffer3.toString();
            uRL2 = new URL(string3);
            httpsURLConnection = (HttpsURLConnection)uRL2.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.addRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            String string4 = "j_username=" + string + "&j_password=" + string2;
            outputStreamWriter.write(string4);
            outputStreamWriter.flush();
            httpsURLConnection.getResponseCode();
            String string5 = httpsURLConnection.getHeaderField("X-com-ibm-team-repository-web-auth-msg");
            if ("authfailed".equals(string5)) {
                throw new SecurityException("jazz login failed");
            }
        }
    }

    public static Map putToServer(URL uRL, String string) throws ProtocolException, IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setRequestMethod("PUT");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
        outputStreamWriter.write(string);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(httpsURLConnection.getHeaderFields());
        hashMap.put(RQM_RESPONSE_CODE, (List<String>)((Object)new Integer(httpsURLConnection.getResponseCode())));
        hashMap.put(RQM_RESPONSE_MESSAGE, (List<String>)((Object)httpsURLConnection.getResponseMessage()));
        InputStream inputStream = null;
        try {
            inputStream = httpsURLConnection.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            hashMap.put(RQM_RESPONSE_CONTENT, (List<String>)((Object)stringBuffer));
            inputStream.close();
            bufferedReader.close();
        }
        httpsURLConnection.disconnect();
        return hashMap;
    }

    public static Map getFromServer(URL uRL) throws ProtocolException, IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestMethod("GET");
        httpsURLConnection.setInstanceFollowRedirects(false);
        String string = httpsURLConnection.getResponseMessage();
        Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
        int n = httpsURLConnection.getResponseCode();
        InputStream inputStream = null;
        try {
            inputStream = httpsURLConnection.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer("");
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(httpsURLConnection.getHeaderFields());
        hashMap.put(RQM_RESPONSE_CODE, (List<String>)((Object)new Integer(n)));
        hashMap.put(RQM_RESPONSE_MESSAGE, (List<String>)((Object)httpsURLConnection.getResponseMessage()));
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            bufferedReader.close();
            hashMap.put(RQM_RESPONSE_CONTENT, (List<String>)((Object)stringBuffer));
        }
        httpsURLConnection.disconnect();
        return hashMap;
    }

    public static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }
}

