/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.integration.client.clientlib;

import com.ibm.rqm.integration.client.clientlib.JFSHttpsClient;
import com.ibm.rqm.integration.client.clientlib.Logger;
import com.ibm.rqm.integration.client.clientlib.SSLContextUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class RQMConnectionHelper {
    private static final int MAX_RETRIES = 2;
    private static final int RETRY_DELAY = 3000;
    private static final String AUTHENTICATION_HEADER_NAME = "X-com-ibm-team-repository-web-auth-msg";
    private static final String AUTHENTICATION_HEADER_VAL = "authrequired";
    public static final String RQM_RESPONSE_CONTENT = "rqm_responseContent";
    public static final String RQM_RESPONSE_MESSAGE = "rqm_responseMessage";
    public static final String RQM_RESPONSE_CODE = "rqm_responseCode";
    public static final String RQM_RESPONSE_HEADER = "rqm_responseHeader";
    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String RQM_AUTH_RESPONSE = "X-com-ibm-team-repository-web-auth-msg";
    public static final String HTTP_HEADER_USER_AGENT_NAME = "User-Agent";
    public static final String HTTP_HEADER_USER_AGENT_VALUE = "RQMConnectionHelper/v0.1";
    private static String m_sCookie = "";
    private static String m_sCreds = "";
    private static Map m_cookieMap = null;
    private static final String SESSION_KEY = "JSESSIONID";
    private static final String WAS_KEY = "LtpaToken";
    private static boolean bFollowRedirect = false;
    private static JFSHttpsClient httpClient = null;
    private static String httpClientUrl = null;
    private static String httpClientUser = null;
    private static String httpClientPassword = null;
    private static MultiThreadedHttpConnectionManager connectionManager = null;

    public static boolean isFollowRedirect() {
        return bFollowRedirect;
    }

    public static void setFollowRedirect(boolean bl) {
        bFollowRedirect = bl;
    }

    public static void clearCookie() {
        bFollowRedirect = false;
        m_sCookie = "";
    }

    public static void setRQMDefaultCookieHandler() {
    }

    public static SSLContext getTrustingSSLContext() {
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        };
        return SSLContextUtil.createSSLContext(x509TrustManager);
    }

    public static void login(URL uRL, String string, String string2) throws ProtocolException, IOException, URISyntaxException {
        RQMConnectionHelper.login(uRL, string, string2, null, null, null, null);
    }

    public static void login(URL uRL, String string, String string2, String string3, String string4, String string5, String string6) throws ProtocolException, IOException, URISyntaxException {
        String string7 = uRL.getPath();
        if (string7.startsWith("/")) {
            string7 = string7.substring(string7.indexOf("/") + 1);
        }
        String string8 = uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + "/" + string7;
        RQMConnectionHelper.debug("login: " + string8);
        if (httpClient != null && httpClientUrl.equals(string8) && httpClientUser.equals(string) && httpClientPassword.equals(string2)) {
            RQMConnectionHelper.debug("User already authenticated, just keep going and let the relogin support handle timeouts");
            httpClient.relogin();
        } else {
            if (httpClient != null) {
                RQMConnectionHelper.debug("New credentials or server, clear current login");
            }
            try {
                int n = 10;
                try {
                    String string9 = System.getenv("MAX_ADAPTER_CONNECTIONS");
                    if (string9 != null) {
                        n = Integer.parseInt(string9);
                    }
                }
                catch (Exception exception) {
                    Logger.Log.debug("++++ RQMConnectionHelper: Error while setting maxConnections.", exception);
                }
                RQMConnectionHelper.debug("Max connections set to: " + n);
                connectionManager = new MultiThreadedHttpConnectionManager();
                connectionManager.getParams().setDefaultMaxConnectionsPerHost(n);
                connectionManager.getParams().setMaxTotalConnections(n);
                httpClient = new JFSHttpsClient(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string7, connectionManager);
                httpClient.setProxySettings(string3, string4, string5, string6);
                httpClientUrl = string8;
                httpClientUser = string;
                httpClientPassword = string2;
                RQMConnectionHelper.debug("httpClient created");
            }
            catch (Exception exception) {
                RQMConnectionHelper.debug("*** httpClient creation failure: " + exception);
            }
            int n = httpClient.login(string, string2);
            RQMConnectionHelper.debug("login: " + n);
            if (n != 200 && n != 302) {
                RQMConnectionHelper.debug("*** Error logging in to server. Return Code: " + n);
                throw new ProtocolException("Unable to log into server: " + n + ": " + string8);
            }
        }
        RQMConnectionHelper.debugEnd("login");
    }

    public static String getMimeType(String string) throws IOException, MalformedURLException {
        RQMConnectionHelper.debugStart("getMimeType", string);
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n <= 0 || n < string.length() - 1) {
            // empty if block
        }
        Object object = string.substring(n + 1).toLowerCase();
        RQMConnectionHelper.debug("check file suffix: " + (String)object);
        string2 = "jpg".equals(object) ? "image/jpeg" : ("html".equals(object) || "htm".equals(object) ? "text/html" : ("xml".equals(object) ? "text/xml" : ("gif".equals(object) ? "image/gif" : ("png".equals(object) ? "image/png" : ("zip".equals(object) ? "application/zip" : ("csv".equals(object) ? "text/csv" : URLConnection.guessContentTypeFromName(string)))))));
        if (string2 == null || string2.equals("")) {
            System.out.println("+++ Calculating MIME type: " + string);
            object = new URL(string);
            URLConnection uRLConnection = ((URL)object).openConnection();
            string2 = uRLConnection.getContentType();
        }
        RQMConnectionHelper.debug("MimeType: " + string2);
        RQMConnectionHelper.debugEnd("getMimeType");
        return string2;
    }

    public static Map postFileToServer(URL uRL, String string) throws ProtocolException, IOException {
        RQMConnectionHelper.debugStart("postFileToServer", uRL + "," + string);
        Map map = RQMConnectionHelper.postFileToServer(uRL, string, RQMConnectionHelper.getMimeType("file://" + string));
        RQMConnectionHelper.debugEnd("postFileToServer");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map postFileToServer(URL uRL, String string, String string2) throws ProtocolException, IOException {
        RQMConnectionHelper.debugStart("postFileToServer", uRL + "," + string + "," + string2);
        if (string2 == null || string2.trim().length() == 0 || string2.indexOf("/") <= 0) {
            string2 = "text/html";
        }
        PostMethod postMethod = new PostMethod(uRL.toString());
        Header header = new Header(HTTP_HEADER_USER_AGENT_NAME, HTTP_HEADER_USER_AGENT_VALUE);
        postMethod.setRequestHeader(header);
        File file = new File(string);
        Part[] partArray = new Part[]{new FilePart(file.getName(), file, string2, null)};
        MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(partArray, postMethod.getParams());
        postMethod.setRequestEntity(multipartRequestEntity);
        RQMConnectionHelper.debug("POST the file");
        try {
            Object object;
            Object object2;
            int n = RQMConnectionHelper.retryableMethodExecution(postMethod);
            if (RQMConnectionHelper.checkForRelogin(postMethod)) {
                RQMConnectionHelper.debug("POST checkForRelogin");
                postMethod.releaseConnection();
                postMethod = new PostMethod(uRL.toString());
                postMethod.setRequestEntity(multipartRequestEntity);
                n = RQMConnectionHelper.retryableMethodExecution(postMethod);
            }
            RQMConnectionHelper.debug("POST response code: " + n);
            if (n != 200 && n != 201 && n != 302) {
                String string3 = RQMConnectionHelper.getStreamContent(postMethod.getResponseBodyAsStream());
                postMethod.releaseConnection();
                throw new ProtocolException("POST[" + n + "] POST File Artifact: " + string3);
            }
            if (n == 302) {
                RQMConnectionHelper.debug("postFileToServer received 302 response.");
                object2 = postMethod.getResponseHeader("Location");
                while (object2 != null && n == 302) {
                    object = new GetMethod(((NameValuePair)object2).getValue());
                    try {
                        n = httpClient.executeMethod((HttpMethod)object);
                        if (n != 200 && n != 201) {
                            String string4 = RQMConnectionHelper.getStreamContent(postMethod.getResponseBodyAsStream());
                            postMethod.releaseConnection();
                            throw new ProtocolException("POST[" + n + "] POST File Artifact: " + string4);
                        }
                        object2 = ((HttpMethodBase)object).getResponseHeader("Location");
                    }
                    finally {
                        ((HttpMethodBase)object).releaseConnection();
                    }
                }
            }
            object2 = RQMConnectionHelper.getHeaders(postMethod.getResponseHeaders());
            object2.put(RQM_RESPONSE_CODE, new Integer(n));
            object2.put(RQM_RESPONSE_CONTENT, RQMConnectionHelper.getStreamContent(postMethod.getResponseBodyAsStream()));
            RQMConnectionHelper.debug("postFileToServer :");
            RQMConnectionHelper.debug((Map)object2);
            RQMConnectionHelper.debugEnd("postFileToServer");
            postMethod.releaseConnection();
            object = object2;
            return object;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    public static Map postToServer(URL uRL, String string) throws ProtocolException, IOException {
        return RQMConnectionHelper.internalSendToServer(false, uRL, string);
    }

    public static Map putToServer(URL uRL, String string) throws ProtocolException, IOException {
        return RQMConnectionHelper.internalSendToServer(true, uRL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map internalSendToServer(boolean bl, URL uRL, String string) throws ProtocolException, IOException {
        RQMConnectionHelper.debugStart("internalSendToServer", uRL + "," + string);
        String string2 = uRL.toString();
        EntityEnclosingMethod entityEnclosingMethod = bl ? new PutMethod(string2) : new PostMethod(string2);
        Header header = new Header(HTTP_HEADER_USER_AGENT_NAME, HTTP_HEADER_USER_AGENT_VALUE);
        entityEnclosingMethod.setRequestHeader(header);
        StringRequestEntity stringRequestEntity = new StringRequestEntity(string, null, "UTF-8");
        entityEnclosingMethod.setRequestEntity(stringRequestEntity);
        try {
            int n = RQMConnectionHelper.retryableMethodExecution(entityEnclosingMethod);
            if (RQMConnectionHelper.checkForRelogin(entityEnclosingMethod)) {
                entityEnclosingMethod.releaseConnection();
                entityEnclosingMethod = new PutMethod(string2);
                entityEnclosingMethod.setRequestHeader(header);
                entityEnclosingMethod.setRequestEntity(stringRequestEntity);
                n = RQMConnectionHelper.retryableMethodExecution(entityEnclosingMethod);
            }
            if (n != 200 && n != 201) {
                String string3 = RQMConnectionHelper.getStreamContent(entityEnclosingMethod.getResponseBodyAsStream());
                entityEnclosingMethod.releaseConnection();
                throw new ProtocolException(entityEnclosingMethod.getName() + "[" + n + "] : " + string3);
            }
            Map map = RQMConnectionHelper.getHeaders(entityEnclosingMethod.getResponseHeaders());
            map.put(RQM_RESPONSE_CODE, new Integer(n));
            map.put(RQM_RESPONSE_CONTENT, RQMConnectionHelper.getStreamContent(entityEnclosingMethod.getResponseBodyAsStream()));
            entityEnclosingMethod.releaseConnection();
            RQMConnectionHelper.debugEnd("internalSendToServer");
            Map map2 = map;
            return map2;
        }
        finally {
            entityEnclosingMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map deleteFromServer(URL uRL) throws ProtocolException, IOException {
        RQMConnectionHelper.debugStart("deleteFromServer", uRL + "");
        String string = uRL.toString();
        DeleteMethod deleteMethod = new DeleteMethod(string);
        Header header = new Header(HTTP_HEADER_USER_AGENT_NAME, HTTP_HEADER_USER_AGENT_VALUE);
        deleteMethod.setRequestHeader(header);
        try {
            int n = RQMConnectionHelper.retryableMethodExecution(deleteMethod);
            if (RQMConnectionHelper.checkForRelogin(deleteMethod)) {
                deleteMethod.releaseConnection();
                deleteMethod = new DeleteMethod(string);
                deleteMethod.setRequestHeader(header);
                n = RQMConnectionHelper.retryableMethodExecution(deleteMethod);
            }
            Map map = RQMConnectionHelper.getHeaders(deleteMethod.getResponseHeaders());
            map.put(RQM_RESPONSE_CODE, new Integer(n));
            deleteMethod.releaseConnection();
            RQMConnectionHelper.debugEnd("deleteToServer");
            Map map2 = map;
            return map2;
        }
        finally {
            deleteMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getFromServer(URL uRL) throws ProtocolException, IOException {
        RQMConnectionHelper.debugStart("getFromServer", uRL.toString());
        GetMethod getMethod = new GetMethod(uRL.toString());
        Header header = new Header(HTTP_HEADER_USER_AGENT_NAME, HTTP_HEADER_USER_AGENT_VALUE);
        getMethod.setRequestHeader(header);
        try {
            int n = RQMConnectionHelper.retryableMethodExecution(getMethod);
            if (RQMConnectionHelper.checkForRelogin(getMethod)) {
                getMethod.releaseConnection();
                getMethod = new GetMethod(uRL.toString());
                getMethod.setRequestHeader(header);
                n = RQMConnectionHelper.retryableMethodExecution(getMethod);
            }
            if (n != 200 && n != 302) {
                String string = RQMConnectionHelper.getStreamContent(getMethod.getResponseBodyAsStream());
                getMethod.releaseConnection();
                throw new ProtocolException("GET [" + n + "] : " + string);
            }
            Map map = RQMConnectionHelper.getHeaders(getMethod.getResponseHeaders());
            String string = RQMConnectionHelper.getStreamContent(getMethod.getResponseBodyAsStream());
            map.put(RQM_RESPONSE_MESSAGE, string);
            map.put(RQM_RESPONSE_CODE, new Integer(n));
            getMethod.releaseConnection();
            RQMConnectionHelper.debug(map);
            RQMConnectionHelper.debugEnd("getFromServer");
            Map map2 = map;
            return map2;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getResourceFromServer(URL uRL, OutputStream outputStream) throws ProtocolException, IOException {
        RQMConnectionHelper.debugStart("getResourceFromServer", uRL.toString());
        GetMethod getMethod = new GetMethod(uRL.toString());
        Header header = new Header(HTTP_HEADER_USER_AGENT_NAME, HTTP_HEADER_USER_AGENT_VALUE);
        getMethod.setRequestHeader(header);
        try {
            Object object2;
            Object object3;
            int n = RQMConnectionHelper.retryableMethodExecution(getMethod);
            if (RQMConnectionHelper.checkForRelogin(getMethod)) {
                getMethod.releaseConnection();
                getMethod = new GetMethod(uRL.toString());
                getMethod.setRequestHeader(header);
                n = RQMConnectionHelper.retryableMethodExecution(getMethod);
            }
            if ((n == 200 || n == 302) && (object3 = getMethod.getResponseBodyAsStream()) != null) {
                object2 = new BufferedInputStream((InputStream)object3);
                byte[] object = new byte[1064];
                int n2 = 0;
                while ((n2 = ((FilterInputStream)object2).read(object)) != -1) {
                    outputStream.write(object, 0, n2);
                }
                ((BufferedInputStream)object2).close();
            }
            object3 = RQMConnectionHelper.getHeaders(getMethod.getResponseHeaders());
            object2 = new HashMap();
            for (Header header2 : getMethod.getResponseHeaders()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(header2.getValue());
                object2.put(header2.getName(), arrayList);
            }
            object3.put(RQM_RESPONSE_HEADER, object2);
            object3.put(RQM_RESPONSE_CODE, new Integer(n));
            getMethod.releaseConnection();
            RQMConnectionHelper.debugEnd("getResourceFromServer");
            Object object = object3;
            return object;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getResourceFromServer(URL uRL, OutputStream outputStream, long l) throws ProtocolException, IOException {
        Object object;
        Object object2;
        RQMConnectionHelper.debugStart("getResourceFromServer", uRL.toString() + "," + l);
        GetMethod getMethod = new GetMethod(uRL.toString());
        Header header = new Header(HTTP_HEADER_USER_AGENT_NAME, HTTP_HEADER_USER_AGENT_VALUE);
        getMethod.setRequestHeader(header);
        if (l > 0L) {
            Date date = new Date(l);
            object2 = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("GMT"));
            object = new Header("if-modified-since", ((DateFormat)object2).format(date));
            getMethod.setRequestHeader((Header)object);
        }
        try {
            int n = RQMConnectionHelper.retryableMethodExecution(getMethod);
            if (RQMConnectionHelper.checkForRelogin(getMethod)) {
                getMethod.releaseConnection();
                getMethod = new GetMethod(uRL.toString());
                getMethod.setRequestHeader(header);
                n = RQMConnectionHelper.retryableMethodExecution(getMethod);
            }
            if (n != 304 && (n == 200 || n == 302) && (object2 = getMethod.getResponseBodyAsStream()) != null) {
                object = new BufferedInputStream((InputStream)object2);
                byte[] object3 = new byte[1064];
                int n2 = 0;
                while ((n2 = ((FilterInputStream)object).read(object3)) != -1) {
                    outputStream.write(object3, 0, n2);
                }
                ((BufferedInputStream)object).close();
            }
            object2 = RQMConnectionHelper.getHeaders(getMethod.getResponseHeaders());
            object = new HashMap();
            for (Header header2 : getMethod.getResponseHeaders()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(header2.getValue());
                object.put(header2.getName(), arrayList);
            }
            object2.put(RQM_RESPONSE_HEADER, object);
            object2.put(RQM_RESPONSE_CODE, new Integer(n));
            getMethod.releaseConnection();
            RQMConnectionHelper.debugEnd("getResourceFromServer");
            Object object3 = object2;
            return object3;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }

    public static String httpDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date()) + "GMT";
    }

    protected static Map getHeaders(Header[] headerArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (headerArray != null) {
            for (int i = 0; i < headerArray.length; ++i) {
                hashtable.put(headerArray[i].getName(), headerArray[i].getValue());
            }
        }
        return hashtable;
    }

    protected static int retryableMethodExecution(HttpMethod httpMethod) throws IOException, HttpException {
        int n = -1;
        for (int i = 0; i < 2; ++i) {
            try {
                if (i > 0) {
                    RQMConnectionHelper.debug("retryableMethodExecution - releasing connection before retry.");
                    httpMethod.releaseConnection();
                }
                if ((n = httpClient.executeMethod(httpMethod)) < 400) {
                    break;
                }
            }
            catch (IOException iOException) {
                RQMConnectionHelper.debug(iOException.toString());
                throw iOException;
            }
            RQMConnectionHelper.debug("Error received: " + n + ", retry #: " + i);
            if (httpMethod.getName().equalsIgnoreCase("GET") && n >= 400) break;
            try {
                if (i + 1 >= 2) continue;
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return n;
    }

    protected static boolean checkForRelogin(HttpMethod httpMethod) throws IOException {
        boolean bl = false;
        Header header = httpMethod.getResponseHeader("X-com-ibm-team-repository-web-auth-msg");
        if (header != null && header.getValue() != null && header.getValue().equals(AUTHENTICATION_HEADER_VAL)) {
            RQMConnectionHelper.debug("Authentication expired, relogin required");
            httpClient.relogin();
            bl = true;
        }
        return bl;
    }

    protected static String getStreamContent(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8192];
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStream.read(byArray);
        while (n > 0) {
            stringBuffer.append(new String(byArray, 0, n, "UTF-8"));
            n = inputStream.read(byArray);
        }
        return stringBuffer.toString();
    }

    private static void debug(String string) {
        Logger.Log.debug("++++ RQMConnectionHelper: " + string);
    }

    protected static void debugStart(String string, String string2) {
        Logger.Log.debug("Start " + string + "[" + string2 + "]");
    }

    protected static void debugEnd(String string) {
        Logger.Log.debug("End " + string);
    }

    private static void debug(Map map) {
        if (map == null) {
            Logger.Log.debug("Empty Map???");
        } else {
            for (Object k : map.keySet()) {
                Logger.Log.debug("  " + k + " [" + map.get(k) + "]");
            }
        }
    }
}

