/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.zipwriter;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.zipwriter.InfoZipUtil;
import com.urbancode.commons.util.zipwriter.ZipContentItemBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class ZipContentItemFileStream
extends ZipContentItemBase {
    private final InputStream file;

    private static String normalizePath(String path) {
        if (path != null) {
            path = path.replace('\\', '/');
            path.replaceAll("/+", "/");
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return path;
    }

    public ZipContentItemFileStream(String path, InputStream file, long timestamp, Set<?> permissionViews) {
        super(ZipContentItemFileStream.normalizePath(path), timestamp, permissionViews);
        Check.nonNull(file, "file");
        this.file = file;
    }

    @Override
    void writeContent(OutputStream stream) throws IOException {
        IO.copy(this.file, stream);
    }

    @Override
    InfoZipUtil.Type getType() {
        return InfoZipUtil.Type.FILE;
    }
}

