#!/usr/bin/env groovy
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import java.net.URL
import java.net.MalformedURLException

def apTool = new AirPluginTool(args[0], args[1])
final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def user = props['user'];
println "rqm_properties.user : " + user;

def password = props['password'];
println "rqm_properties.password: " + password;

def repository_url = props['repositoryUrl'];
println "rqm_properties.repository_url: " + repository_url;

try{
	new URL(repository_url);
}catch(MalformedURLException e){
	println "Invalid RQM Repository URL: " + repository_url;
	e.printStackTrace();
    System.exit(1);
}

def project_name = props['projectName'];
println "rqm_properties.project_name: " + project_name;

def test_suite_exec_record_id = props['testSuiteExecRecordId'];
println "test_suite_exec_record_id: " + test_suite_exec_record_id;

def step_script_ids = props['stepScriptIds'];
println "step_script_ids: " + step_script_ids;

def step_adapter_ids = props['stepAdapterIds'];
println "step_adapter_ids: " + step_adapter_ids;

def arguments = props['arguments'];
println "arguments: " + arguments;

def PLUGIN_HOME = System.getenv("PLUGIN_HOME");

def pluginHomeFile = new File(PLUGIN_HOME);
if (!pluginHomeFile.exists()) {
    throw new RuntimeException("Cannot get PLUGIN_HOME");
}

def libDir = new File(pluginHomeFile, "lib");
if (!libDir.exists()) {
    throw new RuntimeException("Cannot get lib directory!");
}

def ant = new AntBuilder();

try {
    ant.path(id:"rqm.classpath") {
      fileset(dir:libDir) {
          include(name:"*.jar")
      }
    }
    
    ant.taskdef(name:"executeTestSuiteER", classname:"com.ibm.rqm.executiontool.RQMExecuteTestSuiteExecRecord", classpathref:"rqm.classpath")

    ant.executeTestSuiteER(userId:"${user}",
    		password:"${password}",
    		rqmServerUrl:"${repository_url}",
    		projectName:"${project_name}",
    		testSuiteExecRecordId:"${test_suite_exec_record_id}",
    		suiteStepScriptIds:"${step_script_ids}",
    		suiteStepAdapterIds:"${step_adapter_ids}",
    		arguments:"${arguments}")
    		
	println "All ant properties are: " + ant.project.properties		
/*    for(p in ant.project.properties){
    	println "Propery:" + p.key + "and Value:" + p.value
    }*/
    
	ant.echo('${rqmExec:verdict}')
    resultVerdict = ant.project.properties.'rqmExec:verdict'
    println "Test suite execution result status:  " + resultVerdict
    
    ant.echo('${rqmExec:result_url}')
    resultURL = ant.project.properties.'rqmExec:result_url'
    println "Test suite execution result url:  " + resultURL
  
   //  Write new environment name to output properties file  
    apTool.setOutputProperty("resultVerdict", resultVerdict);
	apTool.setOutputProperty("resultURL", resultURL);
    apTool.setOutputProperties();
}
catch (Exception ) {
    System.out.println("Error executing test case execution record!");
    e.printStackTrace();
    System.exit(1);
}
