/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.unix;

import com.urbancode.commons.util.environment.Environment;
import com.urbancode.commons.util.processes.Processes;
import com.urbancode.commons.util.unix.Unix;
import java.io.File;
import java.io.IOException;

class IsExecutable {
    private final File file;
    private final Unix unix;
    private final Processes processes;

    public IsExecutable(File file) {
        this(file, new Unix(), new Processes());
    }

    public IsExecutable(File file, Unix unix, Processes processes) {
        this.file = file;
        this.unix = unix;
        this.processes = processes;
    }

    public boolean execute() throws IOException, InterruptedException {
        String[] command = new String[]{this.unix.testPath(), "-x", this.file.getAbsolutePath()};
        ProcessBuilder builder = new ProcessBuilder(command);
        Environment.getGlobalInstance().copyTo(builder.environment());
        Process process = builder.start();
        this.processes.discardOutput(process);
        this.processes.discardError(process);
        int exit = process.waitFor();
        return exit == 0;
    }
}

