/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.unix;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.process.ProcessBuilderImpl;
import com.urbancode.process.jdk7.ProcessBuilder;
import com.urbancode.process.unix.PathSearch;
import com.urbancode.process.unix.UnixProcess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class UnixProcessBuilderImpl
extends ProcessBuilderImpl {
    private Unix unix;

    UnixProcessBuilderImpl(com.urbancode.process.jdk7.ProcessBuilder builder) {
        this(builder, new Unix());
    }

    UnixProcessBuilderImpl(com.urbancode.process.jdk7.ProcessBuilder builder, Unix unix) {
        super(builder);
        this.unix = unix;
    }

    public UnixProcess start() throws IOException {
        InputStream errorStream;
        InputStream inputStream;
        OutputStream outputStream;
        Process process;
        ProcessBuilder jdk5Builder = new ProcessBuilder(this.command);
        Map<String, String> jdk5Env = jdk5Builder.environment();
        jdk5Env.clear();
        jdk5Env.putAll(this.environment);
        jdk5Builder.directory(this.directory);
        jdk5Builder.redirectErrorStream(this.redirectErrorStream);
        if (this.redirectInput.type() == ProcessBuilder.Redirect.Type.PIPE && this.redirectOutput.type() == ProcessBuilder.Redirect.Type.PIPE && (this.redirectErrorStream || this.redirectError.type() == ProcessBuilder.Redirect.Type.PIPE)) {
            process = jdk5Builder.start();
            outputStream = process.getOutputStream();
            inputStream = process.getInputStream();
            errorStream = process.getErrorStream();
        } else {
            File commandFile = new PathSearch((String)this.command.get(0)).locate();
            if (commandFile == null) {
                throw new IOException("File not found: " + (String)this.command.get(0));
            }
            String script = this.createScript(commandFile);
            String[] commandLine = new String[]{this.unix.shPath(), "-c", script};
            jdk5Builder.command(commandLine);
            process = jdk5Builder.start();
            outputStream = process.getOutputStream();
            inputStream = process.getInputStream();
            errorStream = process.getErrorStream();
            if (this.redirectInput.type() != ProcessBuilder.Redirect.Type.PIPE) {
                IO.closeNoThrow((OutputStream)outputStream);
                outputStream = new NullOutputStream();
            }
            if (this.redirectOutput.type() != ProcessBuilder.Redirect.Type.PIPE) {
                IO.closeNoThrow((InputStream)inputStream);
                inputStream = new NullInputStream();
            }
            if (!this.redirectErrorStream && this.redirectError.type() != ProcessBuilder.Redirect.Type.PIPE) {
                IO.closeNoThrow((InputStream)errorStream);
                errorStream = new NullInputStream();
            }
        }
        return new UnixProcess(errorStream, inputStream, outputStream, process);
    }

    private String createScript(File commandFile) {
        StringBuilder sb = new StringBuilder();
        sb.append("exec ");
        sb.append(Unix.escapeSh((String)commandFile.getAbsolutePath()));
        for (int i = 1; i < this.command.size(); ++i) {
            sb.append(" ");
            sb.append(Unix.escapeSh((String)((String)this.command.get(i))));
        }
        if (this.redirectInput.type() == ProcessBuilder.Redirect.Type.READ) {
            File file = this.redirectInput.file();
            sb.append(" <");
            sb.append(Unix.escapeSh((String)file.getAbsolutePath()));
        } else if (this.redirectInput.type() != ProcessBuilder.Redirect.Type.PIPE) {
            throw new AssertionError();
        }
        if (this.redirectOutput.type() == ProcessBuilder.Redirect.Type.WRITE) {
            File file = this.redirectOutput.file();
            sb.append(" >");
            sb.append(Unix.escapeSh((String)file.getAbsolutePath()));
        } else if (this.redirectOutput.type() == ProcessBuilder.Redirect.Type.APPEND) {
            File file = this.redirectOutput.file();
            sb.append(" >>");
            sb.append(Unix.escapeSh((String)file.getAbsolutePath()));
        } else if (this.redirectInput.type() != ProcessBuilder.Redirect.Type.PIPE) {
            throw new AssertionError();
        }
        if (this.redirectErrorStream && this.redirectOutput.type() != ProcessBuilder.Redirect.Type.PIPE) {
            sb.append(" 2>&1");
        } else if (this.redirectError.type() == ProcessBuilder.Redirect.Type.WRITE) {
            File file = this.redirectError.file();
            sb.append(" 2>");
            sb.append(Unix.escapeSh((String)file.getAbsolutePath()));
        } else if (this.redirectError.type() == ProcessBuilder.Redirect.Type.APPEND) {
            File file = this.redirectError.file();
            sb.append(" 2>>");
            sb.append(Unix.escapeSh((String)file.getAbsolutePath()));
        } else if (this.redirectInput.type() != ProcessBuilder.Redirect.Type.PIPE) {
            throw new AssertionError();
        }
        return sb.toString();
    }

    public static class NullOutputStream
    extends OutputStream {
        public void write(int b) throws IOException {
            throw new IOException();
        }
    }

    public static class NullInputStream
    extends InputStream {
        public int read() {
            return -1;
        }

        public int available() {
            return 0;
        }
    }
}

