/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.internal.CommandLineArgumentProcessor;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.ExecutionCommandProcessor;
import com.ibm.rqm.executiontool.util.ExecutionLogger;
import com.ibm.rqm.integration.client.clientlib.Logger;
import java.util.Map;

public class ExecutionUtility {
    private static final String VERSION = "v4.0.1";
    private static Map<String, CommandLineArgumentProcessor.CmdLineArg> cmdArgs = null;
    private static final String HELPSTRING = "RQM Execution Utility\n==================\nStarts Execution of a TestcaseExecutionRecord(TER) or TestSuiteExecutionRecord(TSER).\n\nArgument Reference\n==================\nFor Testcase ExecutionRecord executionExecutionUtility -tcerId -user -password -publicURI -projectName [-scriptId] [-adapterId] [-resultState] [-exitOnComplete] [-variables] \nFor TestSuite ExecutionRecord executionExecutionUtility -tserId -user -password -publicURI -projectName [-haltOnFailure] [-parallelExecution] [-suiteStepScriptIds] [-suiteStepAdapterIds] [-resultState] [-exitOnComplete] [-variables] [-passVariables] \n-help\nPrints this help message\n\n-version\nPrints the version of the Execution Utility\n\n-tcerId=<integer id or externalId>\nInteger id of the TestcaseExecutionRecord to be executed.\n\n-tserId=<integer id>\nInteger id of the TestSuiteExecutionRecord to be executed.\n\n-user=<userid>\nThe userid for a valid user with execution permission in the specified project.\n\n-password=<password>\nThe password for user corresponding to the userid provided.\n\n-publicURI=https://<servername>:port/qm\nBase public URI of the RQM server e.g. https://<servername>:port/qm.\n\n-projectName=<Project area name>\nName of the project area. \n-projectAlias=<Project area alias>\nAlias of the project area. Optional, if specified will override projectName.\n-scriptId=<Web id of the script to be executed>\nNote: If no script specified, then Default script set on TER will be executed.\n\n-adapterId=<Web id of the adapter>\nAdapter on which test to be executed in case of Remote execution..\n\n-resultState=<State of the Result>\nIf specified, execution will be considered 'execute without execution' and result will be created directly with the result state provided.\nList of supported valuees are:com.ibm.rqm.execution.common.state.passed\ncom.ibm.rqm.execution.common.state.failed\ncom.ibm.rqm.execution.common.state.blocked\ncom.ibm.rqm.execution.common.state.part_blocked\ncom.ibm.rqm.execution.common.state.incomplete\ncom.ibm.rqm.execution.common.state.perm_failed\ncom.ibm.rqm.execution.common.state.deferred\ncom.ibm.rqm.execution.common.state.inconclusive\ncom.ibm.rqm.execution.common.state.error\n\n-exitOnComplete=<true or false>\nIf true, command will not exit until execution is completed or cancelled.\nIf false (default), command will exit immediately after triggering execution.\n\n-printResultUrl=<true or false>\nIf true the URL for the associated execution result will be logged.\nNote: For automated test case execution, this option also requires -exitOnComplete=true to be specified.\n\n-variables=<var1Name:var1Value,var2Name:,va3Name:var3Value>\nSpecify Execution variable and optional values to be passed to execution.\nNote: Variable name and value are saperated by colon ':', if value is provided\n\n-haltOnFailure=<true or false>\nTrue to halt execution on failure of any Test Case in the overall Test Suite execution.\nThis is optional and applicable only for serial execution. Default value is as specified in the Testsuite\n\n-parallelExecution=<true or false>\nIf true all suite steps will execute in parallel, sequential otherwise.\nNote: Default value is as specified in the Testsuite level.\n\n-suiteStepScriptIds=1,,4,10\nOptional comma saperated scriptIds for each step in the order of step. Leave blank for a step where not applicable or want to use default script.\nFor instance, to specify scriptId 4 for step 1, script 78 for step 3 for a suite with 5 steps, argument value would be as follows:\n  -suiteStepScriptIds=4,,78,,\n\n-suiteStepAdapterIds=<comma saperated adapter ids for each suite step>\nOptional comma saperated adapter Ids for each step in the order of step. Leave blank for a step where adapter is not required or want RQM to assign an adapter.\nFor instance, to specify adapterId 20 for step 2,  15 for step 3 for a suite with 3 steps, argument value would be as follows:\n  -suiteStepAdapterIds=,20,15\n\n-passVariables=<true or false>\nIf true, variables will be passed from one step to next in the sequential execution of test suite.\n\n-progressCycle=<number in seconds>\nApplicable only when -exitOnComplete=true. This cycle determines the gap between two consecutive check for progress of TER/TCSER.\nDefault value is 10 seconds. If execution is expected to say take 10 minutes then 5 minutes (300 sec) cycle would be idle to avoid too much traffic on server.\n\nUsage\n==================\nExecuting a testcase execution record synchronously:\nExecutionUtility -tcerId=1512 -projectName=\"Quality Manager\" -publicURI=https://localhost:9443/jazz -user=validuser  -password=correctpassword   -scriptId=10 -adapterId=20 -exitOnComplete=true \n\nExecuting a Test suite asynchronously:\nExecutionUtility -tserId=134 -projectName=\"Quality Manager\" -publicURI=https://localhost:9443/jazz -user=validuser  -password=correctpassword   -suiteStepScriptIds=10,23,,45 -suiteStepAdapterIds=20,20,,11 -exitOnComplete=false \n\n";

    public static void main(String[] stringArray) {
        ExecutionUtility executionUtility = new ExecutionUtility();
        System.exit(executionUtility.executeCommands((String[])stringArray).getExitCode().exitCode);
    }

    public ExecResult executeCommands(String[] stringArray) {
        String string = "";
        ExecResult execResult = new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string);
        try {
            cmdArgs = CommandLineArgumentProcessor.processArgs(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ExecutionLogger.logError(illegalArgumentException.toString());
            ExecutionLogger.logInfo(ExecResult.ExitCode.ILLEGAL_ARG.message);
            System.out.println(HELPSTRING);
            return new ExecResult(ExecResult.ExitCode.ILLEGAL_ARG, string);
        }
        if (cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.HELP.name()) != null || cmdArgs.size() == 0) {
            System.out.println(HELPSTRING);
            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, string);
        }
        if (cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.VERSION.name()) != null) {
            System.out.println(ExecutionUtility.getVersion());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, string);
        }
        try {
            ExecutionCommandProcessor executionCommandProcessor = new ExecutionCommandProcessor(cmdArgs);
            execResult = executionCommandProcessor.processCommands();
            ExecutionLogger.logInfo(execResult.getExitCode().message);
        }
        catch (RQMExecutionToolException rQMExecutionToolException) {
            Logger.Log.debug("Internal error: " + rQMExecutionToolException.toString());
            Logger.Log.error(rQMExecutionToolException.getMessage());
            Logger.Log.debug(rQMExecutionToolException.fillInStackTrace());
            ExecutionLogger.logError(rQMExecutionToolException.exitCode.message);
            execResult = new ExecResult(rQMExecutionToolException.exitCode, "");
        }
        return execResult;
    }

    private static String getVersion() {
        return "RQM Execution Utility, version: v4.0.1";
    }
}

