/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.client.ExecutionToolConnectionHelper;
import com.ibm.rqm.executiontool.internal.CommandLineArgumentProcessor;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.PasswordHelper;
import com.ibm.rqm.executiontool.util.ExecutionLogger;
import com.ibm.rqm.executiontool.util.RqmNamespaceContext;
import com.ibm.rqm.integration.client.clientlib.RQMConnectionHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExecutionCommandProcessor {
    private static final String OBJNAME_ADAPTER = "adapter";
    private static final String TERSERVICEPATH = "/service/com.ibm.rqm.execution.common.service.rest.ITestcaseExecutionRecordRestService/executeDTO";
    private static final String TSERSERVICEPATH = "/service/com.ibm.rqm.execution.common.service.rest.ITestSuiteExecutionRecordRestService/execute";
    private static final String SUITESTEPSERVICEPATH = "/service/com.ibm.rqm.planning.common.service.rest.ITestSuiteStepRestService/pagedSearchResult";
    private static final String INTEGRATIONPATH = "/service/com.ibm.rqm.integration.service.IIntegrationService/resources/";
    private static final String PROJECTSPATH = "/service/com.ibm.rqm.integration.service.IIntegrationService/projects/";
    private static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";
    private static final String ALM_QM_NAMESPACE = "http://jazz.net/xmlns/alm/qm/v0.1/";
    private static final String RESULT_URL_LOG_PREFIX = "result url: ";
    private final String INTERNAL_ID_PREFIX = "urn:com.ibm.rqm:";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private final int PAGESIZE = 100;
    private String projectName;
    private String projectAlias;
    private String publicUri;
    private String user;
    private String password;
    private String proxy;
    private String proxyPort;
    private String proxyPassword;
    private String proxyUser;
    private long progressCycle = 10000L;
    private boolean isVerbose = false;
    private int maxRetry = 10;
    private Map<String, CommandLineArgumentProcessor.CmdLineArg> cmdArgs;

    public ExecutionCommandProcessor(Map<String, CommandLineArgumentProcessor.CmdLineArg> map) {
        Object object;
        this.cmdArgs = map;
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PROJECTNAME.name()) != null) {
            this.projectName = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROJECTNAME.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PROJECTALIAS.name()) != null) {
            this.projectAlias = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROJECTALIAS.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PUBLICURI.name()) != null) {
            this.publicUri = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PUBLICURI.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.USER.name()) != null) {
            this.user = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.USER.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PASSWORD.name()) != null) {
            this.password = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PASSWORD.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PASSWORDFILE.name()) != null) {
            object = new File(this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PASSWORDFILE.name()).getVal());
            ExecutionLogger.logInfo("Using passwordFile: " + ((File)object).getAbsolutePath());
            try {
                this.password = PasswordHelper.getPassword((File)object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Problems processing password file");
            }
        }
        if ((object = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROGRESSCHECKCYCLE.name())) != null && ((CommandLineArgumentProcessor.CmdLineArg)((Object)object)).getVal() != null) {
            this.progressCycle = Long.valueOf(((CommandLineArgumentProcessor.CmdLineArg)((Object)object)).getVal());
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.VERBOSE.name()) != null) {
            this.isVerbose = true;
        }
    }

    public ExecResult processCommands() throws RQMExecutionToolException {
        this.login(this.publicUri, this.user, this.password, this.proxy, this.proxyPort, this.proxyUser, this.proxyPassword);
        if (this.projectAlias == null) {
            this.projectAlias = this.getProjectAliasByName(this.projectName);
            if (this.projectAlias == null) {
                ExecutionLogger.logError("Unable to find project: " + this.projectName + ".  Verify the project exist and user running the Execution Utility is a member of the project.");
                return new ExecResult(ExecResult.ExitCode.PROJECT_NOT_FOUND, "");
            }
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.TCERID.name()) != null) {
            return this.processTestCaseExecution();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.TSERID.name()) != null) {
            return this.processTestSuiteExecution();
        }
        throw new IllegalArgumentException("Neither terId or tserId provided.");
    }

    private ExecResult processTestCaseExecution() throws RQMExecutionToolException {
        Object object;
        Object object2;
        Object object3;
        ExecutionLogger.logInfo("Procesing input parameters for TestCase Execution");
        String string = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.TCERID.name()).getVal();
        String string2 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SCRIPTID.name());
        if (cmdLineArg != null) {
            string2 = cmdLineArg.getVal();
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg2 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.ADAPTERID.name());
        String string3 = null;
        if (cmdLineArg2 != null && !this.isInteger(string3 = cmdLineArg2.getVal()) && (string3 = this.getWebID(OBJNAME_ADAPTER, (String)(object3 = this.getObjectURLByName(string3, this.projectAlias, OBJNAME_ADAPTER)))) == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named adapter: " + string3);
        }
        object3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.CHANNELNAME.name());
        String string4 = null;
        String string5 = null;
        if (object3 != null) {
            string4 = ((CommandLineArgumentProcessor.CmdLineArg)((Object)object3)).getVal();
            string5 = this.getChannelIdFromName(string4);
        }
        String string6 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.RESULTSTATE.name());
        if (cmdLineArg3 != null) {
            string6 = cmdLineArg3.getVal();
        }
        boolean bl = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg4 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.name());
        if (cmdLineArg4 != null) {
            bl = Boolean.valueOf(cmdLineArg4.getVal());
        }
        boolean bl2 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg5 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.name());
        if (cmdLineArg5 != null) {
            bl2 = Boolean.valueOf(cmdLineArg5.getVal());
        }
        String string7 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg6 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.VARIABLES.name());
        if (cmdLineArg6 != null) {
            string7 = this.toVariableJson(cmdLineArg6.getVal());
        }
        ArrayList<ExecutionToolConnectionHelper.PostParams> arrayList = new ArrayList<ExecutionToolConnectionHelper.PostParams>();
        ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
        postParams.paramName = "ewiId";
        postParams.paramValue = string;
        arrayList.add(postParams);
        ExecutionToolConnectionHelper.PostParams postParams2 = new ExecutionToolConnectionHelper.PostParams();
        postParams2.paramName = "projectAreaAlias";
        postParams2.paramValue = this.projectAlias;
        arrayList.add(postParams2);
        if (string5 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "channelExternalId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string5;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string2 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "scriptId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string2;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string3 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "adapterId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string3;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string6 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "state";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string6;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
            if (bl2) {
                object = new ExecutionToolConnectionHelper.PostParams();
                ((ExecutionToolConnectionHelper.PostParams)object).paramName = "resolveResult";
                ((ExecutionToolConnectionHelper.PostParams)object).paramValue = "true";
                arrayList.add((ExecutionToolConnectionHelper.PostParams)object);
            }
        }
        if (string7 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "variableJson";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string7;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        object2 = null;
        ExecutionLogger.logInfo("Starting execution");
        object = this.publicUri + TERSERVICEPATH;
        try {
            object2 = ExecutionToolConnectionHelper.postToServer(new URL((String)object), arrayList);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ". Please verify that the adapter being used is running and the values for parameters tcerId, scriptId, adapterId are valid and exist.");
            if (this.isVerbose) {
                ExecutionLogger.logError(protocolException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(malformedURLException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(iOException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        int n = (Integer)object2.get("rqm_responseCode");
        String string8 = "";
        if (n == 200 || n == 201) {
            if (string6 != null) {
                String string9;
                int n2;
                if (bl2 && (n2 = (string9 = (String)object2.get("rqm_responseContent")).indexOf("<result>")) > -1) {
                    int n3 = string9.indexOf("<id>", n2) + "<id>".length();
                    String string10 = string9.substring(n3, string9.indexOf("</id>", n3));
                    string8 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/executionresult/urn:com.ibm.rqm:executionresult:" + string10;
                    ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string8);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_FINISHED, string8);
            }
            ExecutionLogger.logInfo("Execution started");
            String string11 = (String)object2.get("rqm_responseContent");
            int n4 = string11.indexOf("<requestId>") + "<requestId>".length();
            String string12 = string11.substring(n4, string11.indexOf("</requestId>", n4));
            if (string12 != null && string12.trim().length() > 0) {
                int n5 = Integer.valueOf(string12.trim());
                ExecutionLogger.logInfo("Execution instance created on server with request Id " + string12);
                if (bl) {
                    String string13 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/tasks/urn:com.ibm.rqm:tasks:" + n5;
                    URL uRL = null;
                    try {
                        uRL = new URL(string13);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ExecutionLogger.logError("Exception occurred while creating URL for request service: " + string13);
                        if (this.isVerbose) {
                            ExecutionLogger.logError(malformedURLException.getMessage());
                        }
                        return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                    }
                    int n6 = 0;
                    while (true) {
                        String string14;
                        Map map;
                        try {
                            map = ExecutionToolConnectionHelper.getFromServer(uRL);
                        }
                        catch (ProtocolException protocolException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string12 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(protocolException.getMessage());
                            }
                            if (++n6 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                        }
                        catch (IOException iOException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string12 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(iOException.getMessage());
                            }
                            if (++n6 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                        }
                        n = (Integer)map.get("rqm_responseCode");
                        if ((n == 200 || n == 201) && (string14 = (String)map.get("rqm_responseMessage")) != null) {
                            int n7 = string14.indexOf("com.ibm.rqm.executionframework.common.requeststate.");
                            String string15 = string14.substring(n7 + "com.ibm.rqm.executionframework.common.requeststate.".length(), string14.indexOf("</", n7));
                            if (string15.equals("complete")) {
                                ExecutionLogger.logInfo("Execution completed");
                                return this.getResultState(string12, bl2);
                            }
                            if (string15.equals("nottaken")) {
                                ExecutionLogger.logInfo("Waiting to start Execution");
                            } else if (string15.equals("taken")) {
                                int n8 = string14.indexOf("progress>");
                                String string16 = string14.substring(n8 + "progress>".length(), string14.indexOf("</", n8));
                                ExecutionLogger.logInfo("Execution is in progress: " + string16 + "%");
                            } else if (string15.equals("cancelled")) {
                                ExecutionLogger.logInfo("Execution is cancelled");
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_CANCELLED, "");
                            }
                        }
                        try {
                            Thread.sleep(this.progressCycle);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (bl2) {
                    ExecutionLogger.logWarn(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.getArgName() + " argument is required to support " + CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.getArgName() + " option for test case execution.");
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, "");
            }
        }
        ExecutionLogger.logError("Execution request sent to server failed with response code :" + n);
        return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
    }

    private ExecResult processTestSuiteExecution() throws RQMExecutionToolException {
        Object object;
        Object object2;
        ExecutionLogger.logInfo("Procesing input parameters for TestSuite Execution");
        ArrayList<ExecutionToolConnectionHelper.PostParams> arrayList = new ArrayList<ExecutionToolConnectionHelper.PostParams>();
        ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
        postParams.paramName = "projectAreaAlias";
        postParams.paramValue = this.projectAlias;
        arrayList.add(postParams);
        String string = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.TSERID.name()).getVal();
        ExecutionToolConnectionHelper.PostParams postParams2 = new ExecutionToolConnectionHelper.PostParams();
        postParams2.paramName = "id";
        postParams2.paramValue = string;
        arrayList.add(postParams2);
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITESTEPSCRIPTIDS.name());
        String string2 = null;
        if (cmdLineArg != null) {
            string2 = cmdLineArg.getVal();
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg2 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITESTEPADAPTERIDS.name());
        String string3 = null;
        if (cmdLineArg2 != null) {
            string3 = this.checkForAdapterNames(cmdLineArg2.getVal());
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITECHANNELNAME.name());
        String string4 = null;
        String string5 = null;
        if (cmdLineArg3 != null) {
            string4 = cmdLineArg3.getVal();
            string5 = this.getChannelIdFromName(string4);
        }
        String string6 = null;
        if (string2 != null || string3 != null) {
            string6 = this.toSuiteElementJson(string2, string3, string, this.projectAlias);
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "suiteElementsJsonString";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string6;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (null != string5) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "channelExternalId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string5;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        object2 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg4 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.RESULTSTATE.name());
        if (cmdLineArg4 != null) {
            object2 = cmdLineArg4.getVal();
            ExecutionToolConnectionHelper.PostParams postParams3 = new ExecutionToolConnectionHelper.PostParams();
            postParams3.paramName = "state";
            postParams3.paramValue = object2;
            arrayList.add(postParams3);
        }
        boolean bl = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg5 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.name());
        if (cmdLineArg5 != null) {
            bl = Boolean.valueOf(cmdLineArg5.getVal());
        }
        boolean bl2 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg6 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.name());
        if (cmdLineArg6 != null) {
            bl2 = Boolean.valueOf(cmdLineArg6.getVal());
        }
        String string7 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg7 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.VARIABLES.name());
        if (cmdLineArg7 != null) {
            string7 = this.toVariableJson(cmdLineArg7.getVal());
            ExecutionToolConnectionHelper.PostParams postParams4 = new ExecutionToolConnectionHelper.PostParams();
            postParams4.paramName = "suiteVariableJson";
            postParams4.paramValue = string7;
            arrayList.add(postParams4);
        }
        boolean bl3 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg8 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PARALLELEXECUTION.name());
        if (cmdLineArg8 != null) {
            bl3 = Boolean.valueOf(cmdLineArg8.getVal());
            ExecutionToolConnectionHelper.PostParams postParams5 = new ExecutionToolConnectionHelper.PostParams();
            postParams5.paramName = "isSerialExecution";
            postParams5.paramValue = String.valueOf(!bl3);
            arrayList.add(postParams5);
        }
        boolean bl4 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg9 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.HALTONFAILURE.name());
        if (cmdLineArg9 != null) {
            bl4 = Boolean.valueOf(cmdLineArg9.getVal());
            object = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object).paramName = "haltOnFailure";
            ((ExecutionToolConnectionHelper.PostParams)object).paramValue = String.valueOf(bl4);
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object);
        }
        ExecutionLogger.logInfo("Starting execution");
        object = this.publicUri + TSERSERVICEPATH;
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.postToServer(new URL((String)object), arrayList);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ". Please verify that the adapter being used is running and the values for parameters tserId, suiteStepScriptIds, suiteStepAdapterIds are valid and exist.");
            if (this.isVerbose) {
                ExecutionLogger.logError(protocolException.getMessage() + protocolException.toString());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(malformedURLException.getMessage() + malformedURLException.toString());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(iOException.getMessage() + iOException.toString());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        int n = (Integer)map.get("rqm_responseCode");
        if (n == 200 || n == 201) {
            int n2;
            String string8 = null;
            String string9 = (String)map.get("rqm_responseContent");
            String string10 = string9.substring(n2 = string9.indexOf("<id>") + "<id>".length(), string9.indexOf("</id>", n2));
            if (string10 != null && string10.trim().length() > 0) {
                int n3 = Integer.valueOf(string10.trim());
                ExecutionLogger.logInfo("Execution instance created on server with Test Suite Log Id " + string10);
                string8 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/testsuitelog/urn:com.ibm.rqm:testsuitelog:" + n3;
                if (bl2) {
                    ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string8);
                }
            }
            if (object2 != null) {
                return new ExecResult(ExecResult.ExitCode.EXECUTION_FINISHED, string8);
            }
            ExecutionLogger.logInfo("Testsuite Execution started");
            if (string8 != null) {
                if (bl) {
                    URL uRL = null;
                    try {
                        uRL = new URL(string8);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ExecutionLogger.logError("Exception occurred while creating URL for Testsuite log: " + string8);
                        if (this.isVerbose) {
                            ExecutionLogger.logError(malformedURLException.getMessage());
                        }
                        return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, string8);
                    }
                    int n4 = 0;
                    while (true) {
                        String string11;
                        Map map2 = null;
                        try {
                            map2 = ExecutionToolConnectionHelper.getFromServer(uRL);
                        }
                        catch (ProtocolException protocolException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for Testsuite Log:" + string10 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(protocolException.getMessage());
                            }
                            if (++n4 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, string8);
                        }
                        catch (IOException iOException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for Testsuite Log:" + string10 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(iOException.getMessage());
                            }
                            if (++n4 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, string8);
                        }
                        n = (Integer)map2.get("rqm_responseCode");
                        if (n == 200 && (string11 = (String)map2.get("rqm_responseMessage")) != null) {
                            int n5 = string11.indexOf("com.ibm.rqm.execution.common.state.");
                            String string12 = string11.substring(n5 + "com.ibm.rqm.execution.common.state.".length(), string11.indexOf("</", n5));
                            if (string12.equals("inprogress")) {
                                int n6 = string11.indexOf("testcasestotal>");
                                String string13 = string11.substring(n6 + "testcasestotal>".length(), string11.indexOf("</", n6));
                                int n7 = string11.indexOf("testcasesnotstarted>");
                                String string14 = string11.substring(n7 + "testcasesnotstarted>".length(), string11.indexOf("</", n7));
                                int n8 = 0;
                                try {
                                    int n9 = Integer.parseInt(string13);
                                    int n10 = Integer.parseInt(string14);
                                    n8 = (n9 - n10) * 100 / n9;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ExecutionLogger.logInfo("Execution is in progress: " + n8 + "%");
                            } else {
                                ExecutionLogger.logInfo("Test suite execution completed with status " + string12);
                                if (string12.equals("passed")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PASSED, string8);
                                }
                                if (string12.equals("failed")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_FAILED, string8);
                                }
                                if (string12.equals("blocked")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_BLOCKED, string8);
                                }
                                if (string12.equals("error")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string8);
                                }
                                if (string12.equals("inconclusive")) {
                                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCONCLUSIVE, string8);
                                }
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_UNKNOWN, string8);
                            }
                        }
                        try {
                            Thread.sleep(this.progressCycle);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, string8);
            }
        }
        ExecutionLogger.logError("Execution request sent to server failed with response code :" + n);
        return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
    }

    private String getChannelIdFromName(String string) throws RQMExecutionToolException {
        String string2 = "channel";
        String string3 = this.getObjectURLByName(string, this.projectAlias, string2);
        if (string3 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named channel: " + string);
        }
        String string4 = string3.substring(string3.lastIndexOf(47) + 1);
        if (string4 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find ID for channel: " + string);
        }
        return string4;
    }

    private String toSuiteElementJson(String string, String string2, String string3, String string4) throws RQMExecutionToolException {
        String[] stringArray = string != null ? string.split(",") : null;
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        int n = Math.max(stringArray != null ? stringArray.length : 0, stringArray2 != null ? stringArray2.length : 0);
        if (n > 0) {
            list = this.getInternalIdsForSuiteStep(string4, string3);
            stringBuffer.append("[");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("{\"internalId\":\"");
                stringBuffer.append(list.get(i) + "\"");
                if (stringArray != null && stringArray.length >= i + 1 && stringArray[i] != null && stringArray[i].trim().length() > 0) {
                    stringBuffer.append(",\"testScriptId\":\"");
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append("\"");
                }
                if (stringArray2 != null && stringArray2.length >= i + 1 && stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                    stringBuffer.append(",\"adapterId\":\"");
                    stringBuffer.append(stringArray2[i]);
                    stringBuffer.append("\"");
                }
                stringBuffer.append("}");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void login(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws RQMExecutionToolException {
        try {
            HostnameVerifier hostnameVerifier = RQMConnectionHelper.getHostnameVerifier();
            SSLContext sSLContext = RQMConnectionHelper.getTrustingSSLContext();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            ExecutionLogger.logInfo("Successfully created an HTTP client");
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Failed to create an HTTP client" + exception.getMessage());
            throw new RQMExecutionToolException(ExecResult.ExitCode.CONNECTIONERROR, "Failed to create an HTTP client", exception);
        }
        try {
            ExecutionToolConnectionHelper.login(new URL(string), string2, string3, string4, string5, string6, string7);
            ExecutionLogger.logInfo("Connection to RQM Server is established");
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.LOGIN_ERROR, "Failed to connect to RQM Server", exception);
        }
    }

    public String toVariableJson(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":(?=([^']*'[^']*')*[^']*$)");
            String string3 = stringArray2[1];
            if (string3.startsWith("'") && string3.endsWith("'")) {
                stringArray2[1] = string3 = string3.substring(1, string3.length() - 1);
            }
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{\"name\":\"");
            stringBuffer.append(stringArray2[0]);
            stringBuffer.append("\"");
            if (stringArray2.length == 2) {
                stringBuffer.append(",\"value\":\"");
                stringBuffer.append(stringArray2[1]);
                stringBuffer.append("\"");
            }
            stringBuffer.append("}");
            bl = false;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private ExecResult getResultState(String string, boolean bl) throws RQMExecutionToolException {
        String string2;
        URL uRL = null;
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + this.projectAlias + "/tasks/urn:com.ibm.rqm:tasks:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.EXECUTION_COMPLETED, (Throwable)malformedURLException);
        }
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string + ". " + protocolException.getMessage());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string + ". " + iOException.getMessage());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
        }
        Integer n = (Integer)map.get("rqm_responseCode");
        if ((n == 200 || n == 201) && (string2 = (String)map.get("rqm_responseMessage")) != null) {
            int n2 = string2.indexOf("executionresult href=");
            if (n2 == -1) {
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
            }
            String string3 = string2.substring(n2 + "executionresult href=\"".length(), string2.indexOf("\"/>", n2));
            URL uRL2 = null;
            try {
                uRL2 = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.EXECUTION_COMPLETED, (Throwable)malformedURLException);
            }
            if (bl) {
                ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string3);
            }
            try {
                map = ExecutionToolConnectionHelper.getFromServer(uRL2);
            }
            catch (ProtocolException protocolException) {
                ExecutionLogger.logError("Exception occurred while checking execution status for result:" + uRL2 + ". " + protocolException.getMessage());
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, string3);
            }
            catch (IOException iOException) {
                ExecutionLogger.logError("Exception occurred while checking execution status for result:" + uRL2 + ". " + iOException.getMessage());
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, string3);
            }
            n = (Integer)map.get("rqm_responseCode");
            if ((n == 200 || n == 201) && (string2 = (String)map.get("rqm_responseMessage")) != null) {
                n2 = string2.indexOf("com.ibm.rqm.execution.common.state.");
                String string4 = string2.substring(n2 + "com.ibm.rqm.execution.common.state.".length(), string2.indexOf("</", n2));
                if (string4.equals("passed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PASSED, string3);
                }
                if (string4.equals("failed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_FAILED, string3);
                }
                if (string4.equals("blocked")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_BLOCKED, string3);
                }
                if (string4.equals("error")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string3);
                }
                if (string4.equals("inconclusive")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCONCLUSIVE, string3);
                }
                if (string4.equals("incomplete")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCOMPLETE, string3);
                }
                if (string4.equals("perm_failed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PERM_FAILED, string3);
                }
                if (string4.equals("deferred")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_DEFERRED, string3);
                }
                if (string4.equals("part_blocked")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PARBLOCKED, string3);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_UNKNOWN, string3);
            }
        }
        return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
    }

    private String getProjectAliasByName(String string) {
        URL uRL;
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(this.publicUri + PROJECTSPATH);
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while creating URL for Projects: " + malformedURLException.getMessage());
            return null;
        }
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Exception occurred while retrieving list of projects:" + exception.getMessage());
            return null;
        }
        int n = (Integer)map.get("rqm_responseCode");
        if (n == 200) {
            String string2 = (String)map.get("rqm_responseMessage");
            if (string2 != null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(string2.getBytes(ENCODING_UTF_8)));
                    NodeList nodeList = document.getElementsByTagNameNS(ALM_QM_NAMESPACE, "project");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element = (Element)nodeList.item(i);
                        String string3 = element.getElementsByTagNameNS(DC_NAMESPACE, "title").item(0).getTextContent();
                        String string4 = element.getElementsByTagNameNS(ALM_QM_NAMESPACE, "alias").item(0).getTextContent();
                        if (!string.equals(string3)) continue;
                        return string4;
                    }
                }
                catch (Exception exception) {
                    ExecutionLogger.logError("Exception occurred while processing project. error:" + exception.getMessage());
                    return null;
                }
            }
        } else {
            ExecutionLogger.logError("Unable to retreive project data from RQM server.  Response code: " + n);
        }
        return null;
    }

    private String getObjectURLByName(String string, String string2, String string3) throws RQMExecutionToolException {
        URL uRL;
        if (string == null || string2 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, string3 + " name or project alias not specified");
        }
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + string2 + "/" + string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating URL for object list: " + malformedURLException.getMessage());
        }
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL, ExecutionCommandProcessor.createQueryParameter("fields", "feed/entry/content/" + string3 + "[title='" + string + "']/*"));
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while retrieving list of " + string3 + ". Error message:" + exception.getMessage());
        }
        int n = (Integer)map.get("rqm_responseCode");
        if (n == 200) {
            String string4 = (String)map.get("rqm_responseMessage");
            if (string4 != null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setValidating(false);
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(string4.getBytes(ENCODING_UTF_8)));
                    XPathFactory xPathFactory = XPathFactory.newInstance();
                    XPath xPath = xPathFactory.newXPath();
                    xPath.setNamespaceContext(RqmNamespaceContext.instance());
                    Object object = xPath.evaluate("//atom:entry[atom:title='" + string + "']/atom:id/text()", document, XPathConstants.NODESET);
                    NodeList nodeList = (NodeList)object;
                    if (nodeList.getLength() > 1) {
                        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Found multiple " + string3 + " with matching name: " + string);
                    }
                    if (nodeList.getLength() == 0) {
                        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "No " + string3 + " matching name: " + string);
                    }
                    String string5 = nodeList.item(0).getNodeValue();
                    return string5;
                }
                catch (Exception exception) {
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while processing " + string3 + ". Error:" + exception.getMessage());
                }
            }
        } else {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to retreive " + string3 + " data from RQM server.  Response code: " + n);
        }
        return null;
    }

    private List getInternalIdsForSuiteStep(String string, String string2) throws RQMExecutionToolException {
        URL uRL;
        if (string == null || string2 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "project alias or tserID not specified");
        }
        String string3 = null;
        Map map = null;
        String string4 = null;
        String string5 = null;
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + string + "/suiteexecutionrecord/urn:com.ibm.rqm:suiteexecutionrecord:" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating URL for object list: " + malformedURLException.getMessage());
        }
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Exception occurred while retrieving TSER . Error: " + exception.getMessage());
            return null;
        }
        int n = (Integer)map.get("rqm_responseCode");
        try {
            if (n == 200 && (string3 = (String)map.get("rqm_responseMessage")) != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes(ENCODING_UTF_8)));
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                xPath.setNamespaceContext(RqmNamespaceContext.instance());
                NodeList nodeList = document.getElementsByTagNameNS(ALM_QM_NAMESPACE, "projectArea");
                NodeList nodeList2 = document.getElementsByTagNameNS(ALM_QM_NAMESPACE, "testsuite");
                if (nodeList.getLength() <= 0) {
                    ExecutionLogger.logError("Unable to find proj area for TSER: " + string2);
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to find projArea for TSER");
                }
                Element element = (Element)nodeList.item(0);
                String string6 = element.getAttribute("href");
                string4 = string6.substring(string6.lastIndexOf(47) + 1);
                if (nodeList2.getLength() > 0) {
                    element = (Element)nodeList2.item(0);
                    string6 = element.getAttribute("href");
                    string5 = string6.contains("urn:com.ibm.rqm:") ? "&id=" + string6.substring(string6.lastIndexOf(58) + 1) : "&externalId=" + string6.substring(string6.lastIndexOf(47) + 1);
                } else {
                    ExecutionLogger.logError("Unable to find Suite ID for TSER: " + string2);
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to find Suite for TSER");
                }
            }
            return this.buildStepIdList(string4, string5);
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Unable to find proj alias: " + exception.getMessage());
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to find Suite or projItemIdfor TSER");
        }
    }

    private List<String> buildStepIdList(String string, String string2) throws RQMExecutionToolException {
        int n = 0;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "project alias not specified");
        }
        Document document = this.getSuiteStepDocument(string, string2, 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(RqmNamespaceContext.instance());
        NodeList nodeList = document.getElementsByTagName("totalPages");
        String string4 = ((Element)nodeList.item(0)).getTextContent();
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        NodeList nodeList2 = null;
        for (int i = 0; i < n; ++i) {
            if (document != null) {
                nodeList2 = document.getElementsByTagName("results");
                if (nodeList2.getLength() > 0) {
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element = (Element)nodeList2.item(j);
                        NodeList nodeList3 = element.getElementsByTagName("internalId");
                        string3 = nodeList3.item(0).getTextContent();
                        arrayList.add(string3);
                    }
                }
            } else {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Step list document was not returned");
            }
            if (i + 1 >= n) continue;
            document = this.getSuiteStepDocument(string, string2, i + 1);
        }
        return arrayList;
    }

    public Document getSuiteStepDocument(String string, String string2, int n) throws RQMExecutionToolException {
        String string3;
        Map map;
        URL uRL;
        Document document = null;
        try {
            uRL = new URL(this.publicUri + SUITESTEPSERVICEPATH + "?projectAreaItemId=" + string + "&processArea=" + string + "&page=" + n + "&pageSize=" + 100 + string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating URL for suite step: " + malformedURLException.getMessage());
        }
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while getting suitesteps. Error message:" + exception.getMessage());
        }
        int n2 = (Integer)map.get("rqm_responseCode");
        if (n2 == 200 && (string3 = (String)map.get("rqm_responseMessage")) != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes(ENCODING_UTF_8)));
            }
            catch (Exception exception) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while getting suitesteps. Error message:" + exception.getMessage());
            }
        }
        return document;
    }

    private String getWebID(String string, String string2) throws RQMExecutionToolException {
        URL uRL = null;
        Map map = null;
        if (null == string2 || string2.isEmpty()) {
            ExecutionLogger.logError("object URL not specified.");
            return null;
        }
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while creating URL for " + string + ". Error: " + malformedURLException.getMessage());
            return null;
        }
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL);
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Exception occurred while retrieving  " + string + ". Error: " + exception.getMessage());
            return null;
        }
        int n = (Integer)map.get("rqm_responseCode");
        try {
            String string3;
            if (n == 200 && (string3 = (String)map.get("rqm_responseMessage")) != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes(ENCODING_UTF_8)));
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                xPath.setNamespaceContext(RqmNamespaceContext.instance());
                Object object = xPath.evaluate("//jzqm:tooladapter/jzqm:webId/text()", document, XPathConstants.STRING);
                if (object != null) {
                    return (String)object;
                }
                ExecutionLogger.logError("Unable to find adapter webId for adapter: " + string);
                return null;
            }
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Unable to find adapter webId for adapter: " + string + exception.getMessage());
            return null;
        }
        return null;
    }

    private boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private String checkForAdapterNames(String string) throws RQMExecutionToolException {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ",";
        for (String string3 : stringArray = string.split(string2)) {
            if (!this.isInteger(string3)) {
                String string4 = this.getObjectURLByName(string3, this.projectAlias, OBJNAME_ADAPTER);
                if (string4 == null || string4.isEmpty()) {
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named adapter: " + string3);
                }
                string3 = this.getWebID(OBJNAME_ADAPTER, string4);
                if (string3 == null) {
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named adapter: " + string3);
                }
            }
            stringBuffer.append(string3);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String createQueryParameter(String string, String string2) throws RQMExecutionToolException {
        if (string != null && !string.trim().isEmpty() && string2 != null && !string2.trim().isEmpty()) {
            try {
                return string.concat("=").concat(URLEncoder.encode(string2, ENCODING_UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while encoding query parameter value: " + unsupportedEncodingException.getMessage());
            }
        }
        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating query string.");
    }
}

