/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.concurrent.ThreadFactoryListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;

@BridgeMethodsAdded
public class ThreadGroupThreadFactory
implements ThreadFactory {
    final ThreadGroup threadGroup;
    private final Set<ThreadFactoryListener> listeners = Collections.synchronizedSet(new HashSet());

    public ThreadGroupThreadFactory(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this.threadGroup, r);
        Set<ThreadFactoryListener> set = this.listeners;
        synchronized (set) {
            for (ThreadFactoryListener listener : this.listeners) {
                listener.threadCreated(thread);
            }
        }
        return thread;
    }

    public void addThreadFactoryListener(ThreadFactoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeThreadFactoryListener(ThreadFactoryListener listener) {
        this.listeners.remove(listener);
    }
}

