/*******************************************************************************
 * (c) Copyright IBM Corporation 2009, 2011. All Rights Reserved.
 *******************************************************************************/
package com.ibm.rqm.url.client;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;

public class RQMUrlGET {

	public RQMUrlGET(String sAttachURL, String sPath,
			RQMUrlUtlyJRSHttpsClient httpclient, RQMUrlUtlyLogin RQMUrlUtlyLogin)
			throws HttpException, IOException {

		if (sAttachURL.indexOf("attachment") == -1) {
			System.out
					.println("RQMUrlUtility: Calling [ HTTP GET ] method to retrieve XML from a specified URL");

			GetMethod method = new GetMethod(sAttachURL);

			/*
			 * Check for the Server Response for the GET Operation
			 */

			int responseCode = RQMUrlUtlyLogin.getHttpClient().executeMethod(
					method);
			if (responseCode != HttpStatus.SC_OK) {
				System.err.println("RQMUrlUtility: Method failed: "
						+ method.getStatusLine());
				return;
			}
			System.out.println("RQMUrlUtility: Server Response code: "
					+ responseCode);

			if (responseCode < 400) {
				// Read the responseCode body.
				byte[] responseBody = method.getResponseBody();
				BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sPath), "UTF-8"));
				out.write(new String(responseBody, "UTF-8"));
				out.close();
				System.out
						.println("RQMUrlUtility: [ SUCCESS ] XML string retrieved from URL : \""
								+ sAttachURL
								+ " \" is written to file located at -: \" "
								+ sPath + " \"");
			}

		} else {

			/*
			 * If a user wants to download a file referred by the URL, then GET
			 * that file and save it to the path specified at Command Line.
			 */

			System.out
					.println("RQMUrlUtility: Calling [ HTTP GET ] method to download an attachment");

			GetMethod method = new GetMethod(sAttachURL);

			/*
			 * Check for the Server Response for the GET Operation
			 */

			int responseCode = RQMUrlUtlyLogin.getHttpClient().executeMethod(
					method);
			if (responseCode != HttpStatus.SC_OK) {
				System.err.println("RQMUrlUtility: Method failed: "
						+ method.getStatusLine());
				return;
			}
			System.out.println("RQMUrlUtility: Server Response code: "
					+ responseCode);

			if (responseCode < 400) {
				// Read the responseCode body.
				byte[] responseBody = method.getResponseBody();
				Header[] head = method.getResponseHeaders();
				int len = head.length;
				String filename = null;
				for (int i = 0; i < len; i++) {
					Header unk = head[i];
					filename = unk.getValue();
					if ((filename.indexOf("attachment") != -1)
							|| (filename.indexOf("file") != -1)) {
						String matcherStr = "filename=\"";
						int len1 = matcherStr.length();
						int startID = filename.indexOf(matcherStr);
						int endID = filename.lastIndexOf("\"");
						filename = filename.substring(startID + len1, endID);
						break;
					}
				}

				if (!sPath.endsWith("\\"))
					sPath = sPath.concat("-");

				FileOutputStream fos = new FileOutputStream(sPath + filename);
				fos.write(responseBody);
				fos.close();

				System.out
						.println("RQMUrlUtility: [ SUCCESS ] Attachment referred by URL : \""
								+ sAttachURL
								+ " \" is downloaded at -: \" "
								+ sPath + filename + " \"");
			}
		}

	}

}
