/*******************************************************************************
 * (c) Copyright IBM Corporation 2009, 2012. All Rights Reserved.
 *******************************************************************************/
package com.ibm.rqm.url.client;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.RedirectException;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class RQMUrlPUT {
	
	private final String ATTACHMENT_RESOURCE_TYPE = "attachment";	
	private static final Pattern RESOURCE_PATTERN = Pattern.compile("http([s]?)://(.+)(:([0-9]+))?/(.+)/service/com.ibm.rqm.integration.service.IIntegrationService/resources/([^/]+)/([^/]+)(/(.*))?");

	public RQMUrlPUT(String sAttachURL, String sPath,
			RQMUrlUtlyJRSHttpsClient httpclient, RQMUrlUtlyLogin RQMUrlUtlyLogin)
			throws IOException {
		
		if(httpclient == null){
			httpclient = RQMUrlUtlyLogin.getHttpClient();
		}

		System.out
				.println("RQMUrlUtility: Calling [ HTTP PUT ] method to upload XML from a specified file to URL");

		File f = new File(sPath);

		// Check for availability for file

		if (!f.exists() || !f.canRead()) {
			System.out.println("RQMUrlUtility: File at location " + sPath
					+ " doesn't exist or can't be read\n");
			return;
		}
		
		boolean isXMLContextType = true;
		Matcher matcher = RESOURCE_PATTERN.matcher(sAttachURL);
		if(matcher.matches()){
			String resourceType = matcher.group(7);
			if(resourceType.equals(ATTACHMENT_RESOURCE_TYPE)){
				isXMLContextType = false;
			}
		}
		
		PutMethod put = new PutMethod(sAttachURL);
		
		try{
			if(isXMLContextType){
				put.setRequestEntity(new InputStreamRequestEntity(new BufferedInputStream(new FileInputStream(f)), "application/xml"));
			} else{
				//multi-part upload for attachment
				FilePart filePart = new FilePart(f.getName(), f, FilePart.DEFAULT_CHARSET, "UTF-8");
				Part[] parts = { filePart };
				put.setRequestEntity(new MultipartRequestEntity(parts, put.getParams()));
			}
		} catch(FileNotFoundException e){
			System.out.println("RQMUrlUtility: File at location " + sPath
					+ " doesn't exist or can't be read\n");
			return;
		}
		
		
		/*
		 * Check for the Server Response for the GET Operation
		 */
		
		int responseCode = httpclient.executeMethod(put);
		httpclient.followRedirects(put, responseCode);

		System.out.println("RQMUrlUtility: Server Response code: "
				+ responseCode);
		

		if (responseCode == HttpURLConnection.HTTP_MOVED_TEMP) {
			Header location = put.getResponseHeader("Location");
			System.out.println("RQMUrlUtility: >>>>>>>>!!!put returned 302, location = "
							+ location.getValue());
			throw new RedirectException();
		}

		if (responseCode < 400)
			System.out
					.println("RQMUrlUtility: [ SUCCESS ] XML string from file : \""
							+ sPath
							+ "\" written to URL : \""
							+ sAttachURL
							+ " \"");
	}

}
