/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.InfoCollector;
import com.ibm.rqm.executiontool.internal.ServiceParams;
import com.ibm.rqm.integration.client.clientlib.RQMProtocolException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationInfoCollector
extends InfoCollector {
    private static final String CONFIGURATIONS_PATH = "/service/com.ibm.rqm.configmanagement.service.rest.IConfigurationManagementRestService/configurations";

    public ConfigurationInfoCollector(String string) {
        super(string + CONFIGURATIONS_PATH);
    }

    public String getDefaultStreamId(String string) throws RQMExecutionToolException, RQMProtocolException {
        Document document = this.callConfigurationService(string);
        String string2 = this.queryXMLItemText(document, "//projectDefault[text()='true']/../itemId");
        if (string2 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Could not find the default stream");
        }
        return string2;
    }

    public String getStreamIdByName(String string, String string2) throws RQMExecutionToolException, RQMProtocolException {
        Document document = this.callConfigurationService(string);
        String string3 = this.queryXMLItemText(document, "//name[text()='" + string2 + "' and ../stream='true']/../itemId");
        if (string3 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Could not find the stream by name: " + string2);
        }
        return string3;
    }

    public List<Configuration> getStreams(String string) throws RQMExecutionToolException, RQMProtocolException {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        Document document = this.callConfigurationService(string);
        NodeList nodeList = this.queryXMLAsList(document, "//stream[text()='true']/..");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            arrayList.add(new Configuration(this.queryXMLItemText(node, "name"), this.queryXMLItemText(node, "itemId")));
        }
        return arrayList;
    }

    private Document callConfigurationService(String string) throws RQMExecutionToolException, RQMProtocolException {
        String string2 = this.callServer(new ServiceParams("projectArea", string));
        return this.createXMLDocument(string2);
    }

    public static class Configuration {
        public final String name;
        public final String itemId;

        public Configuration(String string, String string2) {
            this.itemId = string2;
            this.name = string;
        }
    }
}

