/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.util.ObfuscationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class PasswordHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPassword(File file) throws GeneralSecurityException, IOException, RQMExecutionToolException {
        if (!file.exists()) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.ILLEGAL_ARG, "Specified password file does not exist.");
        }
        if (file.isDirectory()) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.ILLEGAL_ARG, "Specified password file is a directory.");
        }
        String string = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Properties properties = new Properties();
            properties.loadFromXML(fileInputStream);
            string = properties.getProperty("password");
            if (string == null) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.ILLEGAL_ARG, "No password property found.");
            }
            string = ObfuscationHelper.decryptString(string);
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fileInputStream = new FileInputStream(file);
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[256];
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                stringBuffer.append(new String(byArray, 0, n));
                n = fileInputStream.read(byArray);
            }
            String string2 = stringBuffer.toString();
            if (string2.length() == 0) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.ILLEGAL_ARG, "Invalid password content.");
            }
            string = new String(ObfuscationHelper.decrypt(string2.getBytes()));
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }
}

