/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.integration.client.clientlib;

import com.ibm.rqm.integration.client.clientlib.SSLContextUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class TrustingSSLProtocolSocketFactory
implements ProtocolSocketFactory,
SecureProtocolSocketFactory {
    private SSLContext sslcontext = null;
    private static volatile TrustingSSLProtocolSocketFactory instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TrustingSSLProtocolSocketFactory getInstance() throws GeneralSecurityException {
        if (instance != null) return instance;
        Class<TrustingSSLProtocolSocketFactory> clazz = TrustingSSLProtocolSocketFactory.class;
        synchronized (TrustingSSLProtocolSocketFactory.class) {
            if (instance != null) return instance;
            instance = new TrustingSSLProtocolSocketFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public SSLContext getSSLContext() {
        return this.sslcontext;
    }

    private TrustingSSLProtocolSocketFactory() throws GeneralSecurityException {
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        };
        this.sslcontext = SSLContextUtil.createSSLContext(x509TrustManager);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.sslcontext.getSocketFactory().createSocket(string, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.sslcontext.getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        int n3 = httpConnectionParams.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.sslcontext.getSocketFactory();
        if (n3 == 0) {
            return sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
        socket.bind(inetSocketAddress);
        socket.connect(inetSocketAddress2, n3);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }
}

