/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool;

import com.ibm.rqm.executiontool.ExecutionUtility;
import com.ibm.rqm.executiontool.internal.CommandLineArgumentProcessor;
import com.ibm.rqm.executiontool.internal.ExecResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class RQMExecuteAntTask
extends Task {
    private String arguments;
    private String userId;
    private String password;
    private String passwordFile;
    private String rqmServerURL;
    private String projectName;
    private String configURI;
    protected List<String> cmdArgs = new ArrayList<String>();

    public void addArgsAndExecute() throws BuildException {
        String[] stringArray;
        this.cmdArgs.add("-user=" + this.userId);
        if (this.passwordFile != null) {
            this.cmdArgs.add("-passwordFile=" + this.passwordFile);
        } else {
            this.cmdArgs.add("-password=" + this.password);
        }
        this.cmdArgs.add("-publicURI=" + this.rqmServerURL);
        this.cmdArgs.add("-projectName=" + this.projectName);
        if (this.isSet(this.configURI)) {
            this.cmdArgs.add(this.makeArgument(CommandLineArgumentProcessor.CmdLineArg.CONFIG_CONTEXT, this.configURI));
        }
        if ((stringArray = this.arguments.split(" ")).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.cmdArgs.add(stringArray[i]);
            }
        }
        String[] stringArray2 = new String[this.cmdArgs.size()];
        for (int i = 0; i < this.cmdArgs.size(); ++i) {
            stringArray2[i] = this.cmdArgs.get(i);
        }
        this.executeTestCase(stringArray2);
    }

    public void setArguments(String string) throws BuildException {
        this.arguments = string;
    }

    private void executeTestCase(String[] stringArray) {
        ExecResult execResult = new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, "");
        ExecutionUtility executionUtility = new ExecutionUtility();
        execResult = executionUtility.executeCommands(stringArray);
        this.getProject().setProperty("rqmExec:verdict", execResult.getExitCode().verdict);
        String string = execResult.getResultURL();
        if (string == null) {
            string = "";
        }
        this.getProject().setProperty("rqmExec:result_url", string);
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPasswordFile(String string) {
        this.passwordFile = string;
    }

    public void setRqmServerURL(String string) {
        this.rqmServerURL = string;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public void setConfigURI(String string) {
        this.configURI = string;
    }

    private boolean isSet(String string) {
        return string != null && !this.configURI.trim().isEmpty();
    }

    private String makeArgument(CommandLineArgumentProcessor.CmdLineArg cmdLineArg, String string) {
        return cmdLineArg.getArgName() + "=" + string;
    }
}

