/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.client.ExecutionToolConnectionHelper;
import com.ibm.rqm.executiontool.internal.CommandLineArgumentProcessor;
import com.ibm.rqm.executiontool.internal.ConfigurationInfoCollector;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.InfoCollector;
import com.ibm.rqm.executiontool.internal.PasswordHelper;
import com.ibm.rqm.executiontool.internal.ProjectAreaInfoCollector;
import com.ibm.rqm.executiontool.internal.ServiceParams;
import com.ibm.rqm.executiontool.util.ExecutionLogger;
import com.ibm.rqm.executiontool.util.RqmNamespaceContext;
import com.ibm.rqm.executiontool.util.XMLUtil;
import com.ibm.rqm.integration.client.clientlib.RQMConnectionHelper;
import com.ibm.rqm.integration.client.clientlib.RQMProtocolException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExecutionCommandProcessor {
    private static final String OBJNAME_ADAPTER = "adapter";
    private static final String TERSERVICEPATH = "/service/com.ibm.rqm.execution.common.service.rest.ITestcaseExecutionRecordRestService/executeDTO";
    private static final String TSERSERVICEPATH = "/service/com.ibm.rqm.execution.common.service.rest.ITestSuiteExecutionRecordRestService/execute";
    private static final String SUITESTEPSERVICEPATH = "/service/com.ibm.rqm.planning.common.service.rest.ITestSuiteStepRestService/pagedSearchResult";
    private static final String INTEGRATIONPATH = "/service/com.ibm.rqm.integration.service.IIntegrationService/resources/";
    private static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1/";
    private static final String ALM_QM_NAMESPACE = "http://jazz.net/xmlns/alm/qm/v0.1/";
    private static final String RESULT_URL_LOG_PREFIX = "result url: ";
    private static final String OSLC_CONFIG_PARAM = "oslc_config.context";
    private final String INTERNAL_ID_PREFIX = "urn:com.ibm.rqm:";
    private static final String ENCODING_UTF_8 = "UTF-8";
    private final int PAGESIZE = 100;
    private String streamName;
    private String localConfigurationId;
    private URI configContext;
    private String projectName;
    private String projectAlias;
    private String publicUri;
    private String user;
    private String password;
    private String proxy;
    private String proxyPort;
    private String proxyPassword;
    private String proxyUser;
    private long progressCycle = 10000L;
    private boolean isVerbose = false;
    private int maxRetry = 10;
    private Map<String, CommandLineArgumentProcessor.CmdLineArg> cmdArgs;

    public ExecutionCommandProcessor(Map<String, CommandLineArgumentProcessor.CmdLineArg> map) {
        Object object;
        ExecutionLogger.logInfo("Procesing Command Line arguments for Test Execution");
        this.cmdArgs = map;
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.STREAMID.name()) != null) {
            this.localConfigurationId = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.STREAMID.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.STREAMNAME.name()) != null) {
            this.streamName = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.STREAMNAME.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.CONFIG_CONTEXT.name()) != null) {
            object = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.CONFIG_CONTEXT.name());
            String string = ((CommandLineArgumentProcessor.CmdLineArg)((Object)object)).getVal();
            this.configContext = URI.create(string);
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PROJECTNAME.name()) != null) {
            this.projectName = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROJECTNAME.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PROJECTALIAS.name()) != null) {
            this.projectAlias = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROJECTALIAS.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PUBLICURI.name()) != null) {
            this.publicUri = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PUBLICURI.name()).getVal();
            if (this.publicUri.endsWith("/")) {
                this.publicUri = this.publicUri.substring(0, this.publicUri.length() - 1);
            }
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.USER.name()) != null) {
            this.user = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.USER.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PASSWORD.name()) != null) {
            this.password = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PASSWORD.name()).getVal();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.PASSWORDFILE.name()) != null) {
            object = new File(this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PASSWORDFILE.name()).getVal());
            ExecutionLogger.logInfo("Using passwordFile: " + ((File)object).getAbsolutePath());
            try {
                this.password = PasswordHelper.getPassword((File)object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Problems processing password file");
            }
        }
        if ((object = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PROGRESSCHECKCYCLE.name())) != null && ((CommandLineArgumentProcessor.CmdLineArg)((Object)object)).getVal() != null) {
            this.progressCycle = Long.valueOf(((CommandLineArgumentProcessor.CmdLineArg)((Object)object)).getVal());
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.VERBOSE.name()) != null) {
            this.isVerbose = true;
        }
    }

    public ExecResult processCommands() throws RQMExecutionToolException {
        ProjectAreaInfoCollector.ProjectInfo projectInfo;
        InfoCollector infoCollector;
        ExecutionLogger.logInfo("Logging in to the server");
        this.login(this.publicUri, this.user, this.password, this.proxy, this.proxyPort, this.proxyUser, this.proxyPassword);
        try {
            infoCollector = new ProjectAreaInfoCollector(this.publicUri);
            if (this.projectAlias != null) {
                projectInfo = ((ProjectAreaInfoCollector)infoCollector).getProjectInfoByAlias(this.projectAlias);
                this.projectName = projectInfo.name;
            } else {
                projectInfo = ((ProjectAreaInfoCollector)infoCollector).getProjectInfoByName(this.projectName);
                this.projectAlias = projectInfo.alias;
            }
            ExecutionLogger.logInfo("Using project: " + projectInfo.name + " alias: " + projectInfo.alias);
        }
        catch (RQMExecutionToolException rQMExecutionToolException) {
            ExecutionLogger.logInfo("Resolve project alias name if necessary");
            ExecutionLogger.logError("Unable to find project: " + this.projectName + ".  Verify the project exist and user running the Execution Utility is a member of the project.");
            throw rQMExecutionToolException;
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, exception.getMessage(), exception);
        }
        if (this.configContext == null) {
            try {
                infoCollector = new ConfigurationInfoCollector(this.publicUri);
                if (this.streamName != null) {
                    this.localConfigurationId = ((ConfigurationInfoCollector)infoCollector).getStreamIdByName(projectInfo.itemId, this.streamName);
                } else if (this.localConfigurationId == null) {
                    this.localConfigurationId = ((ConfigurationInfoCollector)infoCollector).getDefaultStreamId(projectInfo.itemId);
                }
                ExecutionLogger.logInfo("Using stream id: " + this.localConfigurationId);
            }
            catch (RQMProtocolException rQMProtocolException) {
                if (rQMProtocolException.getResponseCode() == 400) {
                    ExecutionLogger.logWarn("Server does not support configurations.  No default configuration will be set.");
                }
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to determine default configuration", rQMProtocolException);
            }
        }
        ExecutionLogger.logInfo("Execute Execution Command");
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.TCERID.name()) != null) {
            return this.processTestCaseExecution();
        }
        if (this.cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.TSERID.name()) != null) {
            return this.processTestSuiteExecution();
        }
        throw new IllegalArgumentException("Neither terId nor tserId provided.");
    }

    private ExecResult processTestCaseExecution() throws RQMExecutionToolException {
        Object object;
        Object object2;
        Object object3;
        ExecutionLogger.logInfo("Procesing input parameters for TestCase Execution");
        String string = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.TCERID.name()).getVal();
        String string2 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SCRIPTID.name());
        if (cmdLineArg != null) {
            string2 = cmdLineArg.getVal();
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg2 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.ADAPTERID.name());
        String string3 = null;
        if (cmdLineArg2 != null && !this.isInteger(string3 = cmdLineArg2.getVal()) && (string3 = this.getWebID(OBJNAME_ADAPTER, (String)(object3 = this.getObjectURLByName(string3, this.projectAlias, OBJNAME_ADAPTER)))) == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named adapter: " + string3);
        }
        object3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.CHANNELNAME.name());
        String string4 = null;
        String string5 = null;
        if (object3 != null) {
            string4 = ((CommandLineArgumentProcessor.CmdLineArg)((Object)object3)).getVal();
            string5 = this.getChannelIdFromName(string4);
        }
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.BUILDRECORD.name());
        String string6 = null;
        if (cmdLineArg3 != null) {
            string6 = cmdLineArg3.getVal();
        }
        String string7 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg4 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.RESULTSTATE.name());
        if (cmdLineArg4 != null) {
            string7 = cmdLineArg4.getVal();
        }
        boolean bl = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg5 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.name());
        if (cmdLineArg5 != null) {
            bl = Boolean.valueOf(cmdLineArg5.getVal());
        }
        boolean bl2 = false;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg6 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.name());
        if (cmdLineArg6 != null) {
            bl2 = Boolean.valueOf(cmdLineArg6.getVal());
        }
        String string8 = null;
        CommandLineArgumentProcessor.CmdLineArg cmdLineArg7 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.VARIABLES.name());
        if (cmdLineArg7 != null) {
            string8 = this.toVariableJson(cmdLineArg7.getVal());
        }
        ArrayList<ExecutionToolConnectionHelper.PostParams> arrayList = new ArrayList<ExecutionToolConnectionHelper.PostParams>();
        ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
        postParams.paramName = "ewiId";
        postParams.paramValue = string;
        arrayList.add(postParams);
        ExecutionToolConnectionHelper.PostParams postParams2 = new ExecutionToolConnectionHelper.PostParams();
        postParams2.paramName = "projectAreaAlias";
        postParams2.paramValue = this.projectAlias;
        arrayList.add(postParams2);
        this.addConfigurationParameter(arrayList);
        if (string5 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "channelExternalId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string5;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string2 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "scriptId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string2;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string3 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "adapterId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string3;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string6 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "buildRecordId";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string6;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        if (string7 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "state";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string7;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
            if (bl2) {
                object = new ExecutionToolConnectionHelper.PostParams();
                ((ExecutionToolConnectionHelper.PostParams)object).paramName = "resolveResult";
                ((ExecutionToolConnectionHelper.PostParams)object).paramValue = "true";
                arrayList.add((ExecutionToolConnectionHelper.PostParams)object);
            }
        }
        if (string8 != null) {
            object2 = new ExecutionToolConnectionHelper.PostParams();
            ((ExecutionToolConnectionHelper.PostParams)object2).paramName = "variableJson";
            ((ExecutionToolConnectionHelper.PostParams)object2).paramValue = string8;
            arrayList.add((ExecutionToolConnectionHelper.PostParams)object2);
        }
        object2 = null;
        ExecutionLogger.logInfo("Starting execution");
        object = this.publicUri + TERSERVICEPATH;
        try {
            object2 = ExecutionToolConnectionHelper.postToServer(new URL((String)object), arrayList);
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ". Please verify that the adapter being used is running and the values for parameters tcerId, scriptId, adapterId are valid and exist.");
            if (this.isVerbose) {
                ExecutionLogger.logError(protocolException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(malformedURLException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)object + ".");
            if (this.isVerbose) {
                ExecutionLogger.logError(iOException.getMessage());
            }
            return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
        }
        int n = (Integer)object2.get("rqm_responseCode");
        String string9 = "";
        if (n == 200 || n == 201) {
            int n2;
            String string10;
            if (string7 != null) {
                String string11;
                int n3;
                if (bl2 && (n3 = (string11 = (String)object2.get("rqm_responseContent")).indexOf("<result>")) > -1) {
                    int n4 = string11.indexOf("<id>", n3) + "<id>".length();
                    String string12 = string11.substring(n4, string11.indexOf("</id>", n4));
                    string9 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/executionresult/urn:com.ibm.rqm:executionresult:" + string12;
                    ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string9);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_FINISHED, string9);
            }
            ExecutionLogger.logInfo("Execution started");
            String string13 = (String)object2.get("rqm_responseContent");
            int n5 = string13.indexOf("<requestId>");
            if (n5 >= 0 && (string10 = string13.substring(n2 = n5 + "<requestId>".length(), string13.indexOf("</requestId>", n2))) != null && string10.trim().length() > 0) {
                int n6 = Integer.valueOf(string10.trim());
                ExecutionLogger.logInfo("Execution instance created on server with request Id " + string10);
                if (bl) {
                    String string14 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/tasks/urn:com.ibm.rqm:tasks:" + n6;
                    URL uRL = null;
                    try {
                        uRL = new URL(string14);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ExecutionLogger.logError("Exception occurred while creating URL for request service: " + string14);
                        if (this.isVerbose) {
                            ExecutionLogger.logError(malformedURLException.getMessage());
                        }
                        return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                    }
                    int n7 = 0;
                    while (true) {
                        String string15;
                        Map map;
                        try {
                            map = ExecutionToolConnectionHelper.getFromServer(uRL, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
                        }
                        catch (ProtocolException protocolException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string10 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(protocolException.getMessage());
                            }
                            if (++n7 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                        }
                        catch (IOException iOException) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string10 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(iOException.getMessage());
                            }
                            if (++n7 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, "");
                        }
                        n = (Integer)map.get("rqm_responseCode");
                        if ((n == 200 || n == 201) && (string15 = (String)map.get("rqm_responseMessage")) != null) {
                            int n8 = string15.indexOf("com.ibm.rqm.executionframework.common.requeststate.");
                            String string16 = string15.substring(n8 + "com.ibm.rqm.executionframework.common.requeststate.".length(), string15.indexOf("</", n8));
                            if (string16.equals("complete")) {
                                ExecutionLogger.logInfo("Execution completed");
                                return this.getResultState(string10, bl2);
                            }
                            if (string16.equals("nottaken")) {
                                ExecutionLogger.logInfo("Waiting to start Execution");
                            } else if (string16.equals("taken")) {
                                int n9 = string15.indexOf("progress>");
                                String string17 = string15.substring(n9 + "progress>".length(), string15.indexOf("</", n9));
                                ExecutionLogger.logInfo("Execution is in progress: " + string17 + "%");
                            } else if (string16.equals("cancelled")) {
                                ExecutionLogger.logInfo("Execution is cancelled");
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_CANCELLED, "");
                            }
                        }
                        try {
                            Thread.sleep(this.progressCycle);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (bl2) {
                    ExecutionLogger.logWarn(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.getArgName() + " argument is required to support " + CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.getArgName() + " option for test case execution.");
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, "");
            }
        }
        ExecutionLogger.logError("Execution request sent to server failed with response code :" + n);
        return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
    }

    /*
     * Unable to fully structure code
     */
    private ExecResult processTestSuiteExecution() throws RQMExecutionToolException {
        block51: {
            block52: {
                ExecutionLogger.logInfo("Procesing input parameters for TestSuite Execution");
                var1_1 = new ArrayList<ExecutionToolConnectionHelper.PostParams>();
                var2_2 = new ExecutionToolConnectionHelper.PostParams();
                var2_2.paramName = "projectAreaAlias";
                var2_2.paramValue = this.projectAlias;
                var1_1.add(var2_2);
                var3_3 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.TSERID.name()).getVal();
                var4_4 = new ExecutionToolConnectionHelper.PostParams();
                var4_4.paramName = "id";
                var4_4.paramValue = var3_3;
                var1_1.add(var4_4);
                var5_5 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITESTEPSCRIPTIDS.name());
                var6_6 = null;
                if (var5_5 != null) {
                    var6_6 = var5_5.getVal();
                }
                var7_7 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITESTEPADAPTERIDS.name());
                var8_8 = null;
                if (var7_7 != null) {
                    var8_8 = this.checkForAdapterNames(var7_7.getVal());
                }
                var9_9 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITECHANNELNAME.name());
                var10_10 = null;
                var11_11 = null;
                if (var9_9 != null) {
                    var10_10 = var9_9.getVal();
                    var11_11 = this.getChannelIdFromName(var10_10);
                }
                var12_12 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.SUITEBUILDRECORD.name());
                var13_13 = null;
                if (var12_12 != null) {
                    var13_13 = var12_12.getVal();
                }
                ExecutionLogger.logInfo("Building POST parameters for TestSuite Execution");
                var14_14 = null;
                if (var6_6 != null || var8_8 != null) {
                    var14_14 = this.toSuiteElementJson(var6_6, var8_8, var3_3, this.projectAlias);
                    var15_15 = new ExecutionToolConnectionHelper.PostParams();
                    var15_15.paramName = "suiteElementsJsonString";
                    var15_15.paramValue = var14_14;
                    var1_1.add((ExecutionToolConnectionHelper.PostParams)var15_15);
                }
                if (null != var11_11) {
                    var15_15 = new ExecutionToolConnectionHelper.PostParams();
                    var15_15.paramName = "channelExternalId";
                    var15_15.paramValue = var11_11;
                    var1_1.add((ExecutionToolConnectionHelper.PostParams)var15_15);
                }
                if (var13_13 != null) {
                    var15_15 = new ExecutionToolConnectionHelper.PostParams();
                    var15_15.paramName = "buildRecordId";
                    var15_15.paramValue = var13_13;
                    var1_1.add((ExecutionToolConnectionHelper.PostParams)var15_15);
                }
                var15_15 = null;
                var16_16 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.RESULTSTATE.name());
                if (var16_16 != null) {
                    var15_15 = var16_16.getVal();
                    var17_17 = new ExecutionToolConnectionHelper.PostParams();
                    var17_17.paramName = "state";
                    var17_17.paramValue = var15_15;
                    var1_1.add(var17_17);
                }
                var17_18 = false;
                var18_19 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.EXITONCOMPLETE.name());
                if (var18_19 != null) {
                    var17_18 = Boolean.valueOf(var18_19.getVal());
                }
                var19_20 = false;
                var20_21 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PRINTRESULTURL.name());
                if (var20_21 != null) {
                    var19_20 = Boolean.valueOf(var20_21.getVal());
                }
                var21_22 = null;
                var22_23 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.VARIABLES.name());
                if (var22_23 != null) {
                    var21_22 = this.toVariableJson(var22_23.getVal());
                    var23_24 = new ExecutionToolConnectionHelper.PostParams();
                    var23_24.paramName = "suiteVariableJson";
                    var23_24.paramValue = var21_22;
                    var1_1.add(var23_24);
                }
                var23_25 = false;
                var24_26 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.PARALLELEXECUTION.name());
                if (var24_26 != null) {
                    var23_25 = Boolean.valueOf(var24_26.getVal());
                    var25_27 = new ExecutionToolConnectionHelper.PostParams();
                    var25_27.paramName = "isSerialExecution";
                    var25_27.paramValue = String.valueOf(var23_25 == false);
                    var1_1.add(var25_27);
                }
                var25_28 = false;
                var26_29 = this.cmdArgs.remove(CommandLineArgumentProcessor.CmdLineArg.HALTONFAILURE.name());
                if (var26_29 != null) {
                    var25_28 = Boolean.valueOf(var26_29.getVal());
                    var27_30 = new ExecutionToolConnectionHelper.PostParams();
                    var27_30.paramName = "haltOnFailure";
                    var27_30.paramValue = String.valueOf(var25_28);
                    var1_1.add((ExecutionToolConnectionHelper.PostParams)var27_30);
                }
                this.addConfigurationParameter(var1_1);
                ExecutionLogger.logInfo("Starting execution");
                var27_30 = this.publicUri + "/service/com.ibm.rqm.execution.common.service.rest.ITestSuiteExecutionRecordRestService/execute";
                var28_31 = null;
                try {
                    var28_31 = ExecutionToolConnectionHelper.postToServer(new URL((String)var27_30), var1_1);
                }
                catch (ProtocolException var29_32) {
                    ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)var27_30 + ". Please verify that the adapter being used is running and the values for parameters tserId, suiteStepScriptIds, suiteStepAdapterIds are valid and exist.");
                    if (this.isVerbose) {
                        ExecutionLogger.logError(var29_32.getMessage() + var29_32.toString());
                    }
                    return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
                }
                catch (MalformedURLException var29_33) {
                    ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)var27_30 + ".");
                    if (this.isVerbose) {
                        ExecutionLogger.logError(var29_33.getMessage() + var29_33.toString());
                    }
                    return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
                }
                catch (IOException var29_34) {
                    ExecutionLogger.logError("Exception occurred while doing a post to the server with the URL:" + (String)var27_30 + ".");
                    if (this.isVerbose) {
                        ExecutionLogger.logError(var29_34.getMessage() + var29_34.toString());
                    }
                    return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
                }
                var29_35 = (Integer)var28_31.get("rqm_responseCode");
                if (var29_35 != 200 && var29_35 != 201) break block51;
                var30_36 = null;
                var31_37 = (String)var28_31.get("rqm_responseContent");
                var33_39 = var31_37.substring(var32_38 = var31_37.indexOf("<id>") + "<id>".length(), var31_37.indexOf("</id>", var32_38));
                if (var33_39 != null && var33_39.trim().length() > 0) {
                    var34_40 = Integer.valueOf(var33_39.trim());
                    ExecutionLogger.logInfo("Execution instance created on server with Test Suite Log Id " + var33_39);
                    var30_36 = this.publicUri + "/service/com.ibm.rqm.integration.service.IIntegrationService/resources/" + this.projectAlias + "/testsuitelog/urn:com.ibm.rqm:testsuitelog:" + var34_40;
                    if (var19_20) {
                        ExecutionLogger.logInfo("result url: " + var30_36);
                    }
                }
                if (var15_15 != null) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_FINISHED, var30_36);
                }
                ExecutionLogger.logInfo("Testsuite Execution started");
                if (var30_36 == null) break block51;
                if (!var17_18) break block52;
                var34_41 = null;
                try {
                    var34_41 = new URL(var30_36);
                }
                catch (MalformedURLException var35_42) {
                    ExecutionLogger.logError("Exception occurred while creating URL for Testsuite log: " + var30_36);
                    if (this.isVerbose) {
                        ExecutionLogger.logError(var35_42.getMessage());
                    }
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, var30_36);
                }
                var35_43 = 0;
                while (true) lbl-1000:
                // 6 sources

                {
                    block53: {
                        var36_44 = null;
                        try {
                            var36_44 = ExecutionToolConnectionHelper.getFromServer(var34_41, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
                        }
                        catch (ProtocolException var37_46) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for Testsuite Log:" + var33_39 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(var37_46.getMessage());
                            }
                            if (++var35_43 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, var30_36);
                        }
                        catch (IOException var37_47) {
                            ExecutionLogger.logError("Exception occurred while checking execution status for Testsuite Log:" + var33_39 + ". ");
                            if (this.isVerbose) {
                                ExecutionLogger.logError(var37_47.getMessage());
                            }
                            if (++var35_43 <= this.maxRetry) continue;
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, var30_36);
                        }
                        var29_35 = (Integer)var36_44.get("rqm_responseCode");
                        if (var29_35 != 200) break block53;
                        var37_45 = (String)var36_44.get("rqm_responseMessage");
                        if (var37_45 == null) ** GOTO lbl211
                        var38_49 = var37_45.indexOf("com.ibm.rqm.execution.common.state.");
                        if (var38_49 == -1) {
                            ExecutionLogger.logError("Execution State not found");
                            if (this.isVerbose) {
                                ExecutionLogger.logError("Response XML : " + var37_45);
                            }
                        }
                        if ((var39_50 = var37_45.substring(var38_49 + "com.ibm.rqm.execution.common.state.".length(), var37_45.indexOf("</", var38_49))).equals("inprogress")) {
                            var40_51 = var37_45.indexOf("testcasestotal>");
                            if (var40_51 == -1) {
                                ExecutionLogger.logError("TestCases Count is -1");
                                if (this.isVerbose) {
                                    ExecutionLogger.logError("Response XML : " + var37_45);
                                }
                            }
                            var41_52 = var37_45.substring(var40_51 + "testcasestotal>".length(), var37_45.indexOf("</", var40_51));
                            var42_53 = var37_45.indexOf("testcasesnotstarted>");
                            if (var40_51 == -1) {
                                ExecutionLogger.logError("TestCases Not Started Count is -1");
                                if (this.isVerbose) {
                                    ExecutionLogger.logError("Response XML : " + var37_45);
                                }
                            }
                            var43_54 = var37_45.substring(var42_53 + "testcasesnotstarted>".length(), var37_45.indexOf("</", var42_53));
                            var44_55 = 0;
                            try {
                                var45_56 = Integer.parseInt(var41_52);
                                var46_58 = Integer.parseInt(var43_54);
                                var44_55 = (var45_56 - var46_58) * 100 / var45_56;
                            }
                            catch (Exception var45_57) {
                                ExecutionLogger.logError("Exception occurred while calculating Suite Progress for TestSuite Log:" + var33_39 + ". ");
                                if (this.isVerbose) {
                                    ExecutionLogger.logInfo("Response XML : " + var37_45);
                                    ExecutionLogger.logError(var45_57.getMessage());
                                }
                                if (++var35_43 <= this.maxRetry) continue;
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, var30_36);
                            }
                            ExecutionLogger.logInfo("Execution is in progress: " + var44_55 + "%");
                        } else {
                            ExecutionLogger.logInfo("Test suite execution completed with status " + var39_50);
                            if (var39_50.equals("passed")) {
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_PASSED, var30_36);
                            }
                            if (var39_50.equals("failed")) {
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_FAILED, var30_36);
                            }
                            if (var39_50.equals("blocked")) {
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_BLOCKED, var30_36);
                            }
                            if (var39_50.equals("error")) {
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, var30_36);
                            }
                            if (var39_50.equals("inconclusive")) {
                                return new ExecResult(ExecResult.ExitCode.EXECUTION_INCONCLUSIVE, var30_36);
                            }
                            return new ExecResult(ExecResult.ExitCode.EXECUTION_UNKNOWN, var30_36);
lbl211:
                            // 1 sources

                            ExecutionLogger.logError("Response is NULL");
                        }
                    }
                    try {
                        Thread.sleep(this.progressCycle);
                    }
                    catch (InterruptedException var37_48) {
                        ExecutionLogger.logError("InterruptedException occurred while processing TestSuite Log:" + var33_39 + ". ");
                        if (this.isVerbose) {
                            ExecutionLogger.logError(var37_48.getMessage());
                        }
                        if (++var35_43 > this.maxRetry) ** break;
                        continue;
                        return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED_EXITWITHOUTCOMPLETION, var30_36);
                    }
                    break;
                }
                ** GOTO lbl-1000
            }
            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, var30_36);
        }
        ExecutionLogger.logError("Execution request sent to server failed with response code :" + var29_35);
        return new ExecResult(ExecResult.ExitCode.INTERNALERROR, "");
    }

    private void addConfigurationParameter(List<ExecutionToolConnectionHelper.PostParams> list) {
        if (this.configContext != null) {
            ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
            postParams.paramName = OSLC_CONFIG_PARAM;
            postParams.paramValue = this.configContext.toString();
            list.add(postParams);
        } else if (this.localConfigurationId != null) {
            ExecutionToolConnectionHelper.PostParams postParams = new ExecutionToolConnectionHelper.PostParams();
            postParams.paramName = OSLC_CONFIG_PARAM;
            postParams.paramValue = this.localConfigurationId;
            list.add(postParams);
        }
    }

    private ServiceParams addConfigurationParameter(ServiceParams serviceParams) {
        if (this.configContext != null) {
            serviceParams.addParam(OSLC_CONFIG_PARAM, this.configContext.toString());
        } else if (this.localConfigurationId != null) {
            serviceParams.addParam(OSLC_CONFIG_PARAM, this.localConfigurationId);
        }
        return serviceParams;
    }

    private String getChannelIdFromName(String string) throws RQMExecutionToolException {
        String string2 = "channel";
        String string3 = this.getObjectURLByName(string, this.projectAlias, string2);
        if (string3 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named channel: " + string);
        }
        String string4 = string3.substring(string3.lastIndexOf(47) + 1);
        if (string4 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find ID for channel: " + string);
        }
        return string4;
    }

    private String toSuiteElementJson(String string, String string2, String string3, String string4) throws RQMExecutionToolException {
        String[] stringArray = string != null ? string.split(",") : null;
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        int n = Math.max(stringArray != null ? stringArray.length : 0, stringArray2 != null ? stringArray2.length : 0);
        if (n > 0) {
            list = this.getInternalIdsForSuiteStep(string4, string3);
            stringBuffer.append("[");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("{\"internalId\":\"");
                stringBuffer.append(list.get(i) + "\"");
                if (stringArray != null && stringArray.length >= i + 1 && stringArray[i] != null && stringArray[i].trim().length() > 0) {
                    stringBuffer.append(",\"testScriptId\":\"");
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append("\"");
                }
                if (stringArray2 != null && stringArray2.length >= i + 1 && stringArray2[i] != null && stringArray2[i].trim().length() > 0) {
                    stringBuffer.append(",\"adapterId\":\"");
                    stringBuffer.append(stringArray2[i]);
                    stringBuffer.append("\"");
                }
                stringBuffer.append("}");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public void login(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws RQMExecutionToolException {
        try {
            HostnameVerifier hostnameVerifier = RQMConnectionHelper.getHostnameVerifier();
            SSLContext sSLContext = RQMConnectionHelper.getTrustingSSLContext();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            ExecutionLogger.logInfo("Successfully created an HTTP client");
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Failed to create an HTTP client" + exception.getMessage());
            throw new RQMExecutionToolException(ExecResult.ExitCode.CONNECTIONERROR, "Failed to create an HTTP client", exception);
        }
        try {
            ExecutionToolConnectionHelper.login(new URL(string), string2, string3, string4, string5, string6, string7);
            ExecutionLogger.logInfo("Connection to RQM Server is established");
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.LOGIN_ERROR, "Failed to connect to RQM Server", exception);
        }
    }

    public String toVariableJson(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split(",");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":(?=([^']*'[^']*')*[^']*$)");
            String string3 = stringArray2[1];
            if (string3.startsWith("'") && string3.endsWith("'")) {
                stringArray2[1] = string3 = string3.substring(1, string3.length() - 1);
            }
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append("{\"name\":\"");
            stringBuffer.append(stringArray2[0]);
            stringBuffer.append("\"");
            if (stringArray2.length == 2) {
                stringBuffer.append(",\"value\":\"");
                stringBuffer.append(stringArray2[1]);
                stringBuffer.append("\"");
            }
            stringBuffer.append("}");
            bl = false;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private ExecResult getResultState(String string, boolean bl) throws RQMExecutionToolException {
        String string2;
        URL uRL = null;
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + this.projectAlias + "/tasks/urn:com.ibm.rqm:tasks:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.EXECUTION_COMPLETED, (Throwable)malformedURLException);
        }
        Map map = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
        }
        catch (ProtocolException protocolException) {
            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string + ". " + protocolException.getMessage());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
        }
        catch (IOException iOException) {
            ExecutionLogger.logError("Exception occurred while checking execution status for request:" + string + ". " + iOException.getMessage());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
        }
        Integer n = (Integer)map.get("rqm_responseCode");
        if ((n == 200 || n == 201) && (string2 = (String)map.get("rqm_responseMessage")) != null) {
            int n2 = string2.indexOf("executionresult href=");
            if (n2 == -1) {
                ExecutionLogger.logError("Execution Result href not present");
                if (this.isVerbose) {
                    ExecutionLogger.logError("Response XML : " + string2);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
            }
            String string3 = string2.substring(n2 + "executionresult href=\"".length(), string2.indexOf("\"/>", n2));
            string3 = this.publicUri + INTEGRATIONPATH + this.projectAlias + "/executionresult/" + string3.substring(string3.lastIndexOf(47) + 1);
            URL uRL2 = null;
            try {
                uRL2 = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.EXECUTION_COMPLETED, (Throwable)malformedURLException);
            }
            if (bl) {
                ExecutionLogger.logInfo(RESULT_URL_LOG_PREFIX + string3);
            }
            try {
                map = ExecutionToolConnectionHelper.getFromServer(uRL2, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
            }
            catch (ProtocolException protocolException) {
                ExecutionLogger.logError("Exception occurred while checking execution status for result:" + uRL2 + ". " + protocolException.getMessage());
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, string3);
            }
            catch (IOException iOException) {
                ExecutionLogger.logError("Exception occurred while checking execution status for result:" + uRL2 + ". " + iOException.getMessage());
                return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, string3);
            }
            n = (Integer)map.get("rqm_responseCode");
            if ((n == 200 || n == 201) && (string2 = (String)map.get("rqm_responseMessage")) != null) {
                n2 = string2.indexOf("com.ibm.rqm.execution.common.state.");
                String string4 = string2.substring(n2 + "com.ibm.rqm.execution.common.state.".length(), string2.indexOf("</", n2));
                if (string4.equals("passed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PASSED, string3);
                }
                if (string4.equals("failed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_FAILED, string3);
                }
                if (string4.equals("blocked")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_BLOCKED, string3);
                }
                if (string4.equals("error")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string3);
                }
                if (string4.equals("inconclusive")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCONCLUSIVE, string3);
                }
                if (string4.equals("incomplete")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_INCOMPLETE, string3);
                }
                if (string4.equals("perm_failed")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PERM_FAILED, string3);
                }
                if (string4.equals("deferred")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_DEFERRED, string3);
                }
                if (string4.equals("part_blocked")) {
                    return new ExecResult(ExecResult.ExitCode.EXECUTION_PARBLOCKED, string3);
                }
                return new ExecResult(ExecResult.ExitCode.EXECUTION_UNKNOWN, string3);
            }
        }
        return new ExecResult(ExecResult.ExitCode.EXECUTION_COMPLETED, "");
    }

    private String getObjectURLByName(String string, String string2, String string3) throws RQMExecutionToolException {
        URL uRL;
        if (string == null || string2 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, string3 + " name or project alias not specified");
        }
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + string2 + "/" + string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating URL for object list: " + malformedURLException.getMessage());
        }
        Map map = null;
        try {
            ServiceParams serviceParams = new ServiceParams("fields", "feed/entry/content/" + string3 + "[title='" + string + "']/*");
            this.addConfigurationParameter(serviceParams);
            map = ExecutionToolConnectionHelper.getFromServer(uRL, serviceParams.getAsQueryString());
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while retrieving list of " + string3 + ". Error message:" + exception.getMessage());
        }
        int n = (Integer)map.get("rqm_responseCode");
        if (n == 200) {
            String string4 = (String)map.get("rqm_responseMessage");
            if (string4 != null) {
                try {
                    DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                    Document document = documentBuilder.parse(new ByteArrayInputStream(string4.getBytes(ENCODING_UTF_8)));
                    XPathFactory xPathFactory = XPathFactory.newInstance();
                    XPath xPath = xPathFactory.newXPath();
                    xPath.setNamespaceContext(RqmNamespaceContext.instance());
                    Object object = xPath.evaluate("//atom:entry[atom:title='" + string + "']/atom:id/text()", document, XPathConstants.NODESET);
                    NodeList nodeList = (NodeList)object;
                    if (nodeList.getLength() > 1) {
                        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Found multiple " + string3 + " with matching name: " + string);
                    }
                    if (nodeList.getLength() == 0) {
                        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "No " + string3 + " matching name: " + string);
                    }
                    String string5 = nodeList.item(0).getNodeValue();
                    string5 = this.publicUri + INTEGRATIONPATH + string2 + "/" + string3 + "/" + string5.substring(string5.lastIndexOf(47) + 1);
                    return string5;
                }
                catch (Exception exception) {
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while processing " + string3 + ". Error:" + exception.getMessage());
                }
            }
        } else {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to retreive " + string3 + " data from RQM server.  Response code: " + n);
        }
        return null;
    }

    private List getInternalIdsForSuiteStep(String string, String string2) throws RQMExecutionToolException {
        URL uRL;
        if (string == null || string2 == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "project alias or tserID not specified");
        }
        String string3 = null;
        Map map = null;
        String string4 = null;
        String string5 = null;
        try {
            uRL = new URL(this.publicUri + INTEGRATIONPATH + string + "/suiteexecutionrecord/urn:com.ibm.rqm:suiteexecutionrecord:" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating URL for object list: " + malformedURLException.getMessage());
        }
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Exception occurred while retrieving TSER . Error: " + exception.getMessage());
            return null;
        }
        int n = (Integer)map.get("rqm_responseCode");
        try {
            if (n == 200 && (string3 = (String)map.get("rqm_responseMessage")) != null) {
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes(ENCODING_UTF_8)));
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                xPath.setNamespaceContext(RqmNamespaceContext.instance());
                NodeList nodeList = document.getElementsByTagNameNS(ALM_QM_NAMESPACE, "projectArea");
                NodeList nodeList2 = document.getElementsByTagNameNS(ALM_QM_NAMESPACE, "testsuite");
                if (nodeList.getLength() <= 0) {
                    ExecutionLogger.logError("Unable to find proj area for TSER: " + string2);
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to find projArea for TSER");
                }
                Element element = (Element)nodeList.item(0);
                String string6 = element.getAttribute("href");
                string4 = string6.substring(string6.lastIndexOf(47) + 1);
                if (nodeList2.getLength() > 0) {
                    element = (Element)nodeList2.item(0);
                    string6 = element.getAttribute("href");
                    string5 = string6.contains("urn:com.ibm.rqm:") ? "&id=" + string6.substring(string6.lastIndexOf(58) + 1) : "&externalId=" + string6.substring(string6.lastIndexOf(47) + 1);
                } else {
                    ExecutionLogger.logError("Unable to find Suite ID for TSER: " + string2);
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to find Suite for TSER");
                }
            }
            return this.buildStepIdList(string4, string5);
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Unable to find proj alias: " + exception.getMessage());
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to find Suite or projItemIdfor TSER");
        }
    }

    private List<String> buildStepIdList(String string, String string2) throws RQMExecutionToolException {
        int n = 0;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "project alias not specified");
        }
        Document document = this.getSuiteStepDocument(string, string2, 0);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(RqmNamespaceContext.instance());
        NodeList nodeList = document.getElementsByTagName("totalPages");
        String string4 = ((Element)nodeList.item(0)).getTextContent();
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        NodeList nodeList2 = null;
        for (int i = 0; i < n; ++i) {
            if (document != null) {
                nodeList2 = document.getElementsByTagName("results");
                if (nodeList2.getLength() > 0) {
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        Element element = (Element)nodeList2.item(j);
                        NodeList nodeList3 = element.getElementsByTagName("internalId");
                        string3 = nodeList3.item(0).getTextContent();
                        arrayList.add(string3);
                    }
                }
            } else {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Step list document was not returned");
            }
            if (i + 1 >= n) continue;
            document = this.getSuiteStepDocument(string, string2, i + 1);
        }
        return arrayList;
    }

    public Document getSuiteStepDocument(String string, String string2, int n) throws RQMExecutionToolException {
        String string3;
        Map map;
        URL uRL;
        Document document = null;
        try {
            uRL = new URL(this.publicUri + SUITESTEPSERVICEPATH + "?projectAreaItemId=" + string + "&processArea=" + string + "&page=" + n + "&pageSize=" + 100 + string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating URL for suite step: " + malformedURLException.getMessage());
        }
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while getting suitesteps. Error message:" + exception.getMessage());
        }
        int n2 = (Integer)map.get("rqm_responseCode");
        if (n2 == 200 && (string3 = (String)map.get("rqm_responseMessage")) != null) {
            try {
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes(ENCODING_UTF_8)));
            }
            catch (Exception exception) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while getting suitesteps. Error message:" + exception.getMessage());
            }
        }
        return document;
    }

    private String getWebID(String string, String string2) throws RQMExecutionToolException {
        URL uRL = null;
        Map map = null;
        if (null == string2 || string2.isEmpty()) {
            ExecutionLogger.logError("object URL not specified.");
            return null;
        }
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            ExecutionLogger.logError("Exception occurred while creating URL for " + string + ". Error: " + malformedURLException.getMessage());
            return null;
        }
        try {
            map = ExecutionToolConnectionHelper.getFromServer(uRL, this.addConfigurationParameter(new ServiceParams(new String[0])).getAsQueryString());
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Exception occurred while retrieving  " + string + ". Error: " + exception.getMessage());
            return null;
        }
        int n = (Integer)map.get("rqm_responseCode");
        try {
            String string3;
            if (n == 200 && (string3 = (String)map.get("rqm_responseMessage")) != null) {
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Document document = documentBuilder.parse(new ByteArrayInputStream(string3.getBytes(ENCODING_UTF_8)));
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                xPath.setNamespaceContext(RqmNamespaceContext.instance());
                Object object = xPath.evaluate("//jzqm:tooladapter/jzqm:webId/text()", document, XPathConstants.STRING);
                if (object != null) {
                    return (String)object;
                }
                ExecutionLogger.logError("Unable to find adapter webId for adapter: " + string);
                return null;
            }
        }
        catch (Exception exception) {
            ExecutionLogger.logError("Unable to find adapter webId for adapter: " + string + exception.getMessage());
            return null;
        }
        return null;
    }

    private boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private String checkForAdapterNames(String string) throws RQMExecutionToolException {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ",";
        for (String string3 : stringArray = string.split(string2)) {
            if (!this.isInteger(string3)) {
                String string4 = this.getObjectURLByName(string3, this.projectAlias, OBJNAME_ADAPTER);
                if (string4 == null || string4.isEmpty()) {
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named adapter: " + string3);
                }
                string3 = this.getWebID(OBJNAME_ADAPTER, string4);
                if (string3 == null) {
                    throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Failed to find named adapter: " + string3);
                }
            }
            stringBuffer.append(string3);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String createQueryParameter(String string, String string2) throws RQMExecutionToolException {
        if (string != null && !string.trim().isEmpty() && string2 != null && !string2.trim().isEmpty()) {
            try {
                return string.concat("=").concat(URLEncoder.encode(string2, ENCODING_UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while encoding query parameter value: " + unsupportedEncodingException.getMessage());
            }
        }
        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating query string.");
    }
}

