/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.internal.CommandLineArgumentProcessor;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.ExecutionCommandProcessor;
import com.ibm.rqm.executiontool.util.ExecutionLogger;
import com.ibm.rqm.integration.client.clientlib.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;

public class ExecutionUtility {
    private static final String VERSION = "6.0.1";
    private static Map<String, CommandLineArgumentProcessor.CmdLineArg> cmdArgs = null;

    public static void main(String[] stringArray) {
        ExecutionUtility executionUtility = new ExecutionUtility();
        System.exit(executionUtility.executeCommands((String[])stringArray).getExitCode().exitCode);
    }

    public ExecResult executeCommands(String[] stringArray) {
        String string = "";
        ExecResult execResult = new ExecResult(ExecResult.ExitCode.EXECUTION_ERROR, string);
        try {
            cmdArgs = CommandLineArgumentProcessor.processArgs(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ExecutionLogger.logError(illegalArgumentException.toString());
            ExecutionLogger.logInfo(ExecResult.ExitCode.ILLEGAL_ARG.message);
            this.printHelpContent();
            return new ExecResult(ExecResult.ExitCode.ILLEGAL_ARG, string);
        }
        if (cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.HELP.name()) != null || cmdArgs.size() == 0) {
            this.printHelpContent();
            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, string);
        }
        if (cmdArgs.get(CommandLineArgumentProcessor.CmdLineArg.VERSION.name()) != null) {
            System.out.println(ExecutionUtility.getVersion());
            return new ExecResult(ExecResult.ExitCode.EXECUTION_TRIGERRED, string);
        }
        try {
            ExecutionCommandProcessor executionCommandProcessor = new ExecutionCommandProcessor(cmdArgs);
            execResult = executionCommandProcessor.processCommands();
            ExecutionLogger.logInfo(execResult.getExitCode().message);
        }
        catch (RQMExecutionToolException rQMExecutionToolException) {
            Logger.Log.debug("Internal error: " + rQMExecutionToolException.toString());
            Logger.Log.error(rQMExecutionToolException.getMessage());
            Logger.Log.debug(rQMExecutionToolException.fillInStackTrace());
            ExecutionLogger.logError(rQMExecutionToolException.exitCode.message);
            execResult = new ExecResult(rQMExecutionToolException.exitCode, "");
        }
        return execResult;
    }

    private static String getVersion() {
        return "RQM Execution Utility, version: 6.0.1";
    }

    private void printHelpContent() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("RQMExecutionTool_readme.txt")));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("RQM Execution Utility has terminated due to an error");
        }
    }
}

