/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.client.ExecutionToolConnectionHelper;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.ServiceParams;
import com.ibm.rqm.executiontool.util.RqmNamespaceContext;
import com.ibm.rqm.executiontool.util.XMLUtil;
import com.ibm.rqm.integration.client.clientlib.RQMProtocolException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class InfoCollector {
    protected final String serviceURL;
    protected final String ENCODING_UTF_8 = "UTF-8";

    public InfoCollector(String string) {
        this.serviceURL = string;
    }

    protected String callServer() throws RQMExecutionToolException, RQMProtocolException {
        return this.callServer(new ServiceParams(new String[0]));
    }

    protected String callServer(ServiceParams serviceParams) throws RQMExecutionToolException, RQMProtocolException {
        Map map = null;
        String string = null;
        try {
            map = ExecutionToolConnectionHelper.getFromServer(new URL(this.serviceURL), serviceParams.getAsQueryString());
            string = (String)map.get("rqm_responseMessage");
            if (string == null || string.length() == 0) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "No data returned from server for URL: " + this.serviceURL);
            }
        }
        catch (RQMProtocolException rQMProtocolException) {
            throw rQMProtocolException;
        }
        catch (IOException iOException) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Unable to perform operation on URL: " + this.serviceURL, iOException);
        }
        return string;
    }

    protected NodeList queryXMLAsList(Document document, String string) throws RQMExecutionToolException {
        try {
            XPath xPath = this.createXpathInstanceWithQMNamespaces();
            return (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "unable to execute xpath statement: " + string, exception);
        }
    }

    private XPath createXpathInstanceWithQMNamespaces() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(RqmNamespaceContext.instance());
        return xPath;
    }

    protected Document createXMLDocument(String string) throws RQMExecutionToolException {
        try {
            return XMLUtil.createDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "unable to parse server response as XML", exception);
        }
    }

    protected String queryXMLItemText(Object object, String string) throws RQMExecutionToolException {
        try {
            XPath xPath = this.createXpathInstanceWithQMNamespaces();
            NodeList nodeList = (NodeList)xPath.evaluate(string, object, XPathConstants.NODESET);
            if (nodeList.getLength() == 1) {
                return nodeList.item(0).getTextContent();
            }
            if (nodeList.getLength() > 1) {
                throw new IllegalStateException("There are multiple instances where only 1 is expected for the xpath statement - " + string);
            }
        }
        catch (Exception exception) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "unable to execute xpath statement: " + string, exception);
        }
        return null;
    }
}

