/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.integration.client.clientlib;

import com.ibm.rqm.integration.client.clientlib.SSLContextUtil;
import com.ibm.rqm.integration.client.clientlib.URLUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.CookieHandler;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class RQMConnectionHelperJetty {
    public static final String RQM_RESPONSE_CONTENT = "rqm_responseContent";
    public static final String RQM_RESPONSE_MESSAGE = "rqm_responseMessage";
    public static final String RQM_RESPONSE_CODE = "rqm_responseCode";

    public static void setRQMDefaultCookieHandler() {
        CookieHandler.setDefault(new CookieHandler(){
            private HashMap cookies = new HashMap();

            public Map get(URI uRI, Map map) {
                HashMap hashMap = new HashMap();
                if (this.cookies != null && this.cookies.containsKey(uRI.getHost())) {
                    List list = (List)this.cookies.get(uRI.getHost());
                    String string = list.toString();
                    StringBuilder stringBuilder = new StringBuilder();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (stringBuilder.length() > 1) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append((String)iterator.next());
                    }
                    ArrayList<String> arrayList = new ArrayList<String>(1);
                    arrayList.add(stringBuilder.toString());
                    hashMap.put("Cookie", arrayList);
                }
                return hashMap;
            }

            public void put(URI uRI, Map map) {
                if (map.containsKey("Set-Cookie")) {
                    this.cookies.put(uRI.getHost(), map.get("Set-Cookie"));
                }
            }
        });
    }

    public static SSLContext getTrustingSSLContext() {
        X509TrustManager x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        };
        return SSLContextUtil.createSSLContext(x509TrustManager);
    }

    public static void login(URL uRL, String string, String string2) throws ProtocolException, IOException, URISyntaxException {
        StringBuilder stringBuilder = new StringBuilder(uRL.getProtocol());
        stringBuilder.append("://");
        stringBuilder.append(uRL.getHost());
        stringBuilder.append(":");
        stringBuilder.append(uRL.getPort());
        String string3 = null;
        URL uRL2 = null;
        HttpsURLConnection httpsURLConnection = null;
        OutputStreamWriter outputStreamWriter = null;
        if (CookieHandler.getDefault().get(uRL.toURI(), null).size() < 1) {
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.toString());
            stringBuilder2.append(URLUtil.getIntegrationServicePath(uRL));
            string3 = stringBuilder2.toString();
            uRL2 = new URL(string3);
            httpsURLConnection = (HttpsURLConnection)uRL2.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestMethod("GET");
            outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            outputStreamWriter.flush();
            Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
            StringBuilder stringBuilder3 = new StringBuilder(stringBuilder.toString());
            stringBuilder3.append("/jazz/j_security_check");
            string3 = stringBuilder3.toString();
            uRL2 = new URL(string3);
            httpsURLConnection = (HttpsURLConnection)uRL2.openConnection();
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.addRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
            String string4 = "j_username=" + URLEncoder.encode(string, "UTF-8") + "&j_password=" + URLEncoder.encode(string2, "UTF-8");
            outputStreamWriter.write(string4);
            outputStreamWriter.flush();
            httpsURLConnection.getResponseCode();
            String string5 = httpsURLConnection.getHeaderField("X-com-ibm-team-repository-web-auth-msg");
            if ("authfailed".equals(string5)) {
                throw new SecurityException("jazz login failed");
            }
        }
    }

    public static Map putToServer(URL uRL, String string) throws ProtocolException, IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setRequestMethod("PUT");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpsURLConnection.getOutputStream());
        StringRequestEntity stringRequestEntity = new StringRequestEntity(string, null, "UTF-8");
        outputStreamWriter.write(stringRequestEntity.getContent());
        outputStreamWriter.flush();
        outputStreamWriter.close();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(httpsURLConnection.getHeaderFields());
        hashMap.put(RQM_RESPONSE_CODE, (List<String>)((Object)new Integer(httpsURLConnection.getResponseCode())));
        hashMap.put(RQM_RESPONSE_MESSAGE, (List<String>)((Object)httpsURLConnection.getResponseMessage()));
        InputStream inputStream = null;
        try {
            inputStream = httpsURLConnection.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            hashMap.put(RQM_RESPONSE_CONTENT, (List<String>)((Object)stringBuilder));
            inputStream.close();
            bufferedReader.close();
        }
        httpsURLConnection.disconnect();
        return hashMap;
    }

    public static Map getFromServer(URL uRL) throws ProtocolException, IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestMethod("GET");
        httpsURLConnection.setInstanceFollowRedirects(false);
        String string = httpsURLConnection.getResponseMessage();
        Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
        int n = httpsURLConnection.getResponseCode();
        InputStream inputStream = null;
        try {
            inputStream = httpsURLConnection.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder("");
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(httpsURLConnection.getHeaderFields());
        hashMap.put(RQM_RESPONSE_CODE, (List<String>)((Object)new Integer(n)));
        hashMap.put(RQM_RESPONSE_MESSAGE, (List<String>)((Object)httpsURLConnection.getResponseMessage()));
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2 + "\n");
            }
            bufferedReader.close();
            hashMap.put(RQM_RESPONSE_CONTENT, (List<String>)((Object)stringBuilder));
        }
        httpsURLConnection.disconnect();
        return hashMap;
    }

    public static HostnameVerifier getHostnameVerifier() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        return hostnameVerifier;
    }
}

