/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.externalsort;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.externalsort.ExternalSort;
import com.urbancode.commons.util.externalsort.RecordIOFactory;
import com.urbancode.commons.util.externalsort.SortOperation;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class DefaultExternalSort<T>
implements ExternalSort<T> {
    private static final Logger log = Logger.getLogger(DefaultExternalSort.class);
    private final RecordIOFactory<T> factory;
    private final int maxRecordsInMemory;
    private final int maxOpenFiles;
    private final File tempDirectory;
    private final Comparator<? super T> comparator;

    DefaultExternalSort(RecordIOFactory<T> factory, int maxRecordsInMemory, int maxOpenFiles, File tempDirectory, Comparator<? super T> comparator) {
        if (maxRecordsInMemory < 2) {
            throw new IllegalArgumentException();
        }
        if (maxOpenFiles < 2) {
            throw new IllegalArgumentException();
        }
        this.factory = Check.nonNull(factory, "factory");
        this.maxRecordsInMemory = maxRecordsInMemory;
        this.maxOpenFiles = maxOpenFiles;
        this.tempDirectory = tempDirectory;
        this.comparator = Check.nonNull(comparator, "comparator");
    }

    @Override
    public void sort(File source) throws IOException {
        this.sort(source, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(File source, File destination) throws IOException {
        File tempDirectory = this.tempDirectory;
        if (tempDirectory == null) {
            tempDirectory = destination.getAbsoluteFile().getParentFile();
        }
        SortOperation<T> operation = new SortOperation<T>(this.factory, this.maxRecordsInMemory, this.maxOpenFiles, tempDirectory, this.comparator, source, destination);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting sort");
        }
        long start = System.currentTimeMillis();
        try {
            operation.doSort();
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sort completed in " + duration + "ms"));
            }
        }
    }
}

