/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.internal.ExecResult;
import com.ibm.rqm.executiontool.internal.InfoCollector;
import com.ibm.rqm.executiontool.internal.ServiceParams;
import com.ibm.rqm.integration.client.clientlib.RQMProtocolException;
import java.net.URI;
import org.w3c.dom.Document;

public class ProjectAreaInfoCollector
extends InfoCollector {
    private static final String PROJECTSPATH = "/service/com.ibm.rqm.integration.service.IIntegrationService/projects/";

    public ProjectAreaInfoCollector(String string) {
        super(string + PROJECTSPATH);
    }

    public ProjectInfo getProjectInfoByName(String string) throws RQMExecutionToolException, RQMProtocolException {
        ProjectInfo projectInfo = this.getProjectInfoByAlias("dc:title", string);
        if (projectInfo == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.PROJECT_NOT_FOUND, "Could not find the project area for project area name " + string);
        }
        return projectInfo;
    }

    public ProjectInfo getProjectInfoByAlias(String string) throws RQMExecutionToolException, RQMProtocolException {
        ProjectInfo projectInfo = this.getProjectInfoByAlias("jzqm:alias", string);
        if (projectInfo == null) {
            throw new RQMExecutionToolException(ExecResult.ExitCode.PROJECT_NOT_FOUND, "Could not find the project area for project area alias " + string);
        }
        return projectInfo;
    }

    public ProjectInfo getProjectInfoByAlias(String string, String string2) throws RQMExecutionToolException, RQMProtocolException {
        ServiceParams serviceParams = new ServiceParams("abbreviate", "false");
        while (!serviceParams.getParams().isEmpty()) {
            String[] stringArray;
            String string3;
            String string4;
            Document document = this.createXMLDocument(this.callServer(serviceParams));
            String string5 = this.queryXMLItemText(document, "//jzqm:project/" + string + "[text()='" + string2 + "']/../jzqm:projectArea/@href");
            if (string5 != null && !string5.trim().isEmpty()) {
                string4 = this.queryXMLItemText(document, "//jzqm:project/" + string + "[text()='" + string2 + "']/../dc:title");
                string3 = this.queryXMLItemText(document, "//jzqm:project/" + string + "[text()='" + string2 + "']/../jzqm:alias");
                if (string4 != null && !string4.trim().isEmpty() && string3 != null && !string3.trim().isEmpty()) {
                    return new ProjectInfo(string4, string3, this.getItemIdFromHref(string5));
                }
            }
            if ((string4 = this.queryXMLItemText(document, "//atom:feed/atom:link[@rel='next']/@href")) == null || string4.trim().isEmpty()) break;
            serviceParams = new ServiceParams(new String[0]);
            string3 = URI.create(string4).getQuery();
            if (string3 == null || string3.trim().isEmpty() || (stringArray = string3.split("&")).length <= 0) continue;
            for (String string6 : stringArray) {
                String[] stringArray2 = string6.split("=", 2);
                serviceParams.addParam(stringArray2[0], stringArray2[1]);
            }
        }
        return null;
    }

    private String getItemIdFromHref(String string) {
        String[] stringArray = string.split("/");
        return stringArray[stringArray.length - 1];
    }

    public static class ProjectInfo {
        public final String name;
        public final String itemId;
        public final String alias;

        public ProjectInfo(String string, String string2, String string3) {
            this.itemId = string3;
            this.name = string;
            this.alias = string2;
        }
    }
}

