/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.executiontool.internal;

import com.ibm.rqm.executiontool.RQMExecutionToolException;
import com.ibm.rqm.executiontool.internal.ExecResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ServiceParams {
    List<Param> params = new ArrayList<Param>();

    public ServiceParams(String ... stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            this.addParam(stringArray[i], stringArray[i + 1]);
        }
    }

    public void addParam(String string, String string2) {
        this.params.add(new Param(string, string2));
    }

    public void addParam(String string, boolean bl) {
        this.params.add(new Param(string, String.valueOf(bl)));
    }

    public List<Param> getParams() {
        return new ArrayList<Param>(this.params);
    }

    public String getAsQueryString() throws RQMExecutionToolException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Param param : this.params) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(this.createQueryParameter(param.paramName, param.paramValue));
        }
        return stringBuilder.toString();
    }

    private String createQueryParameter(String string, String string2) throws RQMExecutionToolException {
        if (string != null && !string.trim().isEmpty() && string2 != null && !string2.trim().isEmpty()) {
            try {
                return string.concat("=").concat(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while encoding query parameter value: " + unsupportedEncodingException.getMessage());
            }
        }
        throw new RQMExecutionToolException(ExecResult.ExitCode.INTERNALERROR, "Exception occurred while creating query string.");
    }

    public static class Param {
        public final String paramName;
        public final String paramValue;

        public Param(String string, String string2) {
            this.paramName = string;
            this.paramValue = string2;
        }
    }
}

