/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.integration.client.clientlib;

import com.ibm.rqm.integration.client.clientlib.Logger;
import com.ibm.rqm.integration.client.clientlib.TrustingSSLProtocolSocketFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;

public class JFSHttpsClient
extends HttpClient {
    private String protocol;
    private String host;
    private int port;
    private String username;
    private String password;
    protected URL serverURL;
    private String path;
    private String proxy;
    private String proxyPort;
    private String proxyUser;
    private String proxyPwd;
    private Boolean usingBasicAuth = false;
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";

    protected JFSHttpsClient(String string, String string2, int n, String string3, MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager) throws MalformedURLException, GeneralSecurityException {
        super(multiThreadedHttpConnectionManager);
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.serverURL = new URL(this.protocol, this.host, this.port, "/");
        this.path = string3;
        this.getParams().setParameter("http.protocol.single-cookie-header", true);
        String string4 = System.getenv("RQM_CLIENT_COOKIE_POLICY");
        if (string4 == null) {
            string4 = "compatibility";
        }
        this.getParams().setCookiePolicy(string4);
        this.registerTrustingSSL();
    }

    public void setProxySettings(String string, String string2, String string3, String string4) {
        this.proxy = string;
        this.proxyPort = string2;
        this.proxyUser = string3;
        this.proxyPwd = string4;
        this.setProxyCredentials();
    }

    private void registerTrustingSSL() throws GeneralSecurityException {
        Protocol.registerProtocol("https", new Protocol("https", TrustingSSLProtocolSocketFactory.getInstance(), 443));
    }

    public int relogin() throws IOException {
        return this.login(this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int login(String string, String string2) throws IOException {
        Object object;
        Header header;
        int n;
        block28: {
            Object object2;
            Header header2;
            this.username = string;
            this.password = string2;
            GetMethod getMethod = new GetMethod(this.serverURL.toString() + this.path + "/auth/authrequired");
            try {
                n = super.executeMethod(getMethod);
                header = getMethod.getResponseHeader("Location");
                header2 = getMethod.getResponseHeader("X-com-ibm-team-repository-web-auth-uri");
            }
            finally {
                getMethod.releaseConnection();
            }
            this.followRedirects(header, n);
            GetMethod getMethod2 = new GetMethod(this.serverURL.toString() + this.path + "/authenticated/identity");
            try {
                n = super.executeMethod(getMethod2);
                if (n == 401 && (object = getMethod2.getResponseHeader(WWW_AUTHENTICATE_HEADER)) != null && ((NameValuePair)object).getValue().toLowerCase(Locale.ENGLISH).indexOf("basic realm") == 0) {
                    this.usingBasicAuth = true;
                    super.getState().setCredentials(new AuthScope(this.host, this.port), new UsernamePasswordCredentials(string, string2));
                    getMethod2.releaseConnection();
                    getMethod2 = new GetMethod(this.serverURL.toString() + this.path + "/authenticated/identity");
                    n = super.executeMethod(getMethod2);
                    if (n != 200 && n != 302) {
                        object2 = "";
                        try {
                            object2 = getMethod2.getResponseBodyAsString();
                            getMethod2.releaseConnection();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Logger.Log.error("login error (response code) - " + n + "\nResponse Body: " + (String)object2);
                    }
                }
                header = getMethod2.getResponseHeader("Location");
            }
            finally {
                getMethod2.releaseConnection();
            }
            this.followRedirects(header, n);
            if (!this.usingBasicAuth.booleanValue()) {
                object = null;
                if (header2 == null) {
                    object = new PostMethod(this.serverURL.toString() + this.path + "/j_security_check");
                } else {
                    object2 = header2.getValue();
                    object = new PostMethod((String)object2);
                }
                object2 = new NameValuePair[]{new NameValuePair("j_username", string), new NameValuePair("j_password", string2)};
                ((PostMethod)object).addParameters((NameValuePair[])object2);
                ((HttpMethodBase)object).addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                try {
                    n = super.executeMethod((HttpMethod)object);
                    Header header3 = ((HttpMethodBase)object).getResponseHeader("X-com-ibm-team-repository-web-auth-msg");
                    if (header3 != null && "authfailed".equals(header3.getValue())) {
                        int n2 = 401;
                        return n2;
                    }
                    header = ((HttpMethodBase)object).getResponseHeader("Location");
                    if (header != null && header.getValue().indexOf("authfailed") >= 0) {
                        int n3 = 401;
                        return n3;
                    }
                    if (n != 200 && n != 302) {
                        String string3 = "";
                        try {
                            string3 = ((HttpMethodBase)object).getResponseBodyAsString();
                            ((HttpMethodBase)object).releaseConnection();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Logger.Log.error("login error (response code) - " + n + "\nResponse Body: " + string3);
                        break block28;
                    }
                    header = ((HttpMethodBase)object).getResponseHeader("Location");
                    ((HttpMethodBase)object).releaseConnection();
                    this.followRedirects(header, n);
                }
                finally {
                    ((HttpMethodBase)object).releaseConnection();
                }
            }
        }
        object = new GetMethod(this.serverURL.toString() + this.path + "/service/com.ibm.team.repository.service.internal.webuiInitializer.IWebUIInitializerRestService/initializationData");
        try {
            n = this.executeMethod((HttpMethod)object);
            header = ((HttpMethodBase)object).getResponseHeader("Location");
        }
        finally {
            ((HttpMethodBase)object).releaseConnection();
        }
        this.followRedirects(header, n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void followRedirects(Header header, int n) throws IOException {
        while (header != null && n == 302) {
            GetMethod getMethod = new GetMethod(header.getValue());
            try {
                n = this.executeMethod(getMethod);
                if (n != 200) {
                    Logger.Log.debug("after login, attempt to access init data returned: " + n + " for location: " + header);
                }
                header = getMethod.getResponseHeader("Location");
            }
            finally {
                getMethod.releaseConnection();
            }
        }
    }

    @Override
    public int executeMethod(HttpMethod httpMethod) throws HttpException, IOException {
        return super.executeMethod(httpMethod);
    }

    private void setProxyCredentials() {
        if (this.proxy != null && this.proxyPort != null) {
            this.getHostConfiguration().setProxy(this.proxy, new Integer(this.proxyPort));
            if (this.proxyUser != null && this.proxyPwd != null) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.proxyUser, this.proxyPwd);
                AuthScope authScope = new AuthScope(this.proxy, Integer.valueOf(this.proxyPort));
                this.getState().setProxyCredentials(authScope, usernamePasswordCredentials);
            }
        }
    }
}

