/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rqm.integration.client.clientlib;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextUtil {
    public static final String SSL_TLS = "SSL_TLS";
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";

    public static SSLContext createSSLContext(TrustManager trustManager) {
        SSLContext sSLContext = null;
        String string = System.getProperty("com.ibm.team.repository.transport.client.protocol");
        if (string != null) {
            System.out.println("Attempting to create protocol context using system property: " + string);
            sSLContext = SSLContextUtil.createSSLContext(string, trustManager);
        }
        if (sSLContext == null) {
            System.out.println("Attempting to create SSL_TLS context");
            sSLContext = SSLContextUtil.createSSLContext(SSL_TLS, trustManager);
        }
        if (sSLContext == null) {
            System.out.println("Unable to create SSL_TLS context, trying TLS");
            sSLContext = SSLContextUtil.createSSLContext(TLS, trustManager);
        }
        if (sSLContext == null) {
            System.out.println("Unable to create TLS context, trying SSL");
            sSLContext = SSLContextUtil.createSSLContext(SSL, trustManager);
        }
        if (sSLContext == null) {
            throw new RuntimeException("No acceptable encryption algorithm found");
        }
        return sSLContext;
    }

    private static SSLContext createSSLContext(String string, TrustManager trustManager) {
        SSLContext sSLContext;
        try {
            sSLContext = SSLContext.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println(noSuchAlgorithmException);
            return null;
        }
        try {
            sSLContext.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException keyManagementException) {
            System.out.println(keyManagementException);
            return null;
        }
        try {
            Socket socket = sSLContext.getSocketFactory().createSocket();
            socket.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            return null;
        }
        return sSLContext;
    }
}

