/*******************************************************************************
 * (c) Copyright IBM Corporation 2009, 2012. All Rights Reserved.
 *******************************************************************************/
package com.ibm.rqm.url.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class RQMUrlPOST {
	
	private final String ATTACHMENT_RESOURCE_TYPE = "attachment";	
	private static final Pattern RESOURCE_PATTERN = Pattern.compile("http([s]?)://(.+)(:([0-9]+))?/(.+)/service/com.ibm.rqm.integration.service.IIntegrationService/resources/([^/]+)/([^/]+)(/(.*))?");

	public RQMUrlPOST(String sAttachURL, String sPath,
			RQMUrlUtlyJRSHttpsClient httpclient, RQMUrlUtlyLogin RQMUrlUtlyLogin)
			throws IOException {

		if(httpclient == null){
			httpclient = RQMUrlUtlyLogin.getHttpClient();
		}
		
		System.out
				.println("RQMUrlUtility: Calling [ HTTP POST ] method to upload XML from a specified file to URL");

		File f = new File(sPath);

		// Check for availability for file

		if (!f.exists() || !f.canRead()) {
			System.out.println("RQMUrlUtility: File at location " + sPath
					+ " doesn't exist or can't be read\n");
			return;
		}

		PostMethod method = new PostMethod(sAttachURL);
		FilePart filePart = null;
		
		boolean isXMLContextType = true;
		Matcher matcher = RESOURCE_PATTERN.matcher(sAttachURL);
		if(matcher.matches()){
			String resourceType = matcher.group(7);
			if(resourceType.equals(ATTACHMENT_RESOURCE_TYPE)){
				isXMLContextType = false;
			}
		}
		
		try{
			if(isXMLContextType){
				filePart = new FilePart(f.getName(), f, "application/xml", "UTF-8");
			} else{
				filePart = new FilePart(f.getName(), f, FilePart.DEFAULT_CHARSET, "UTF-8");
			}
		} catch (FileNotFoundException e){
			System.out.println("RQMUrlUtility: File at location " + sPath
					+ " doesn't exist or can't be read\n");
			return;
		}
		
		Part[] parts = { filePart };
		method.setRequestEntity(new MultipartRequestEntity(parts, method
				.getParams()));

		/*
		 * Check for the Server Response for the GET Operation
		 */

		int responseCode = httpclient.executeMethod(method);

		System.out.println("RQMUrlUtility: Server Response code: "
				+ responseCode);

		if (responseCode < 400)
			System.out.println("RQMUrlUtility: [ SUCCESS ] File : \"" + sPath
					+ "\" successfully posted to URL : \"" + sAttachURL + " \"");

	}
}
