/*******************************************************************************
 * (c) Copyright IBM Corporation 2009, 2012. All Rights Reserved.
 *******************************************************************************/
package com.ibm.rqm.url.client;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;

public class RQMUrlUtlyLogin {
	private RQMUrlUtlyJRSHttpsClient httpclient;
	@SuppressWarnings("unused")
	private String baseUrl;

	@SuppressWarnings( { "unused", "serial" })
	private class RedirectException extends RuntimeException {
	}

	/**
	 * Object used to log in to the RQM server.
	 * 
	 * @param host
	 *            the host name of the RQM server.
	 * @param port
	 *            the port of the RQM server.
	 * @param project
	 *            the project area on the RQM server that you will be logging in
	 *            to.
	 */
	public RQMUrlUtlyLogin(String protocol, String host, int port, String project) {
		try {
			httpclient = new RQMUrlUtlyJRSHttpsClient(protocol, host, port);
		} catch (MalformedURLException e) {
			System.out.println("RQMUrlUtility: Cannot connect to server " + e);
			System.exit(1);
		}

		System.out.println("RQMUrlUtility: Connected to " + protocol + "://" + host + ":" + port
				+ " using project \"" + project + '\"');
		String encodedProject = project;

		try {
			encodedProject = java.net.URLEncoder.encode(project, "UTF-8");
		} catch (Exception e) {
			System.out.println("RQMUrlUtility: Exception encoding project "
					+ project + " - \n" + e);
		}
		baseUrl = protocol 
				+ "://"
				+ host
				+ ":"
				+ port
				+ "/jazz/secure/service/com.ibm.rqm.integration.service.IIntegrationService/resources/"
				+ encodedProject + "/";
	}

	public RQMUrlUtlyJRSHttpsClient getHttpClient() {
		return httpclient;
	}

	private String userid;
	private String password;
	private String context;

	/**
	 * Reauthenticate to the RQM server. Should only be called after
	 * <code>login</code>.
	 * 
	 * @return HTTP return code of the login.
	 */
	public int relogin() {
		return login(this.userid, this.password, this.context);
	}
	
	/**
	 * Log out the RQM server with the specified context.
	 * 
	 * @param context
	 */
	public void logout(String context)
	{
		httpclient.logout(context); 
	}

	/**
	 * Log in to the RQM server with the specified user name and password.
	 * 
	 * @param userid
	 * @param password
	 * @param context
	 * @return HTTP return code of the login.
	 */
	public int login(String userid, String password, String context) {
		this.userid = userid;
		this.password = password;
		this.context = context;
		int code = 0;
		try {
			httpclient.registerTrustingSSL();
			int ret = httpclient.login(userid, password, context);
			if (ret == HttpURLConnection.HTTP_UNAUTHORIZED) {
				System.out
						.println("RQMUrlUtility: Cannot authenticate to server for user "
								+ userid);
				code = -1;
			} else if (ret == HttpURLConnection.HTTP_CLIENT_TIMEOUT) {
				System.out
						.println("RQMUrlUtility: Timeout authenticating to server for user "
								+ userid);
				code = -1;
			}
		} catch (Exception e) {
			System.out.println("RQMUrlUtility: Cannot authenticate to server "
					+ e);
			code = -1;
		}
		return code;
	}
}