#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import java.net.URL
import java.net.MalformedURLException

def apTool = new AirPluginTool(args[0], args[1])

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def user = props['user'];
println "rqm_properties.user : " + user;

def password = props['password'];
println "rqm_properties.password: " + password;

def repository_url = props['repositoryUrl'];
println "rqm_properties.repository_url: " + repository_url;
try{
    new URL(repository_url);
}catch(MalformedURLException e){
    println "Invalid RQM Repository URL: " + repository_url;
    e.printStackTrace();
    System.exit(1);
}

def project_name = props['projectName'];
println "rqm_properties.project_name: " + project_name;

def test_case_exec_record_id = props['testCaseExecRecordId'];
println "test_case_exec_record_id: " + test_case_exec_record_id;

def scriptId = props['scriptId'];
println "scriptId: " + scriptId;

def adapterId = props['adapterId'];
println "adapterId: " + adapterId;

def arguments = props['arguments'];
println "arguments: " + arguments;

def PLUGIN_HOME = System.getenv("PLUGIN_HOME");

def pluginHomeFile = new File(PLUGIN_HOME);
if (!pluginHomeFile.exists()) {
    throw new RuntimeException("Cannot get PLUGIN_HOME");
}

def libDir = new File(pluginHomeFile, "lib");
if (!libDir.exists()) {
    throw new RuntimeException("Cannot get lib directory!");
}

def ant = new AntBuilder();

try {
    ant.path(id:"rqm.classpath") {
      fileset(dir:libDir) {
          include(name:"*.jar")
      }
    }

    ant.taskdef(name:"executeTestCaseER", classname:"com.ibm.rqm.executiontool.RQMExecuteTestCaseExecRecord", classpathref:"rqm.classpath")

    ant.executeTestCaseER(userId:"${user}",
            password:"${password}",
            rqmServerUrl:"${repository_url}",
            projectName:"${project_name}",
            testCaseExecRecordId:"${test_case_exec_record_id}",
            scriptId:"${scriptId}",
            adapterId:"${adapterId}",
            arguments:"${arguments}")
    println "All ant properties are: " + ant.project.properties
/*    for(p in ant.project.properties){
        println "Propery:" + p.key + "and Value:" + p.value
    }*/

    ant.echo('${rqmExec:verdict}')
    resultVerdict = ant.project.properties.'rqmExec:verdict'

    if (!resultVerdict.contains("passed")) {
        println("Test case execution record: ${test_case_exec_record_id} failed execution with a test case execution result status of: ${resultVerdict}")
        System.exit(1)
    }

    println "Test case execution result status:  " + resultVerdict

    ant.echo('${rqmExec:result_url}')
    resultURL = ant.project.properties.'rqmExec:result_url'
    println "Test case execution result url:  " + resultURL

     //Write new environment name to output properties file
    apTool.setOutputProperty("resultVerdict", resultVerdict);
    apTool.setOutputProperty("resultURL", resultURL);
    apTool.setOutputProperties();
}
catch (Exception e ) {    System.out.println("Error executing test case execution record!");
    e.printStackTrace();
    System.exit(1);
}
