/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.immutable.IImmutableVector;
import com.urbancode.commons.util.immutable.ImmutableVector;
import com.urbancode.commons.util.immutable.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
abstract class AImmutableVector<T>
implements IImmutableVector<T>,
RandomAccess {
    int _hash = -1;

    public String toString() {
        return Util.toString(this, this.iterator());
    }

    @Override
    public boolean equals(Object object) {
        return Util.equals(this, object);
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            this._hash = Util.hashCode(this);
        }
        return this._hash;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Util.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Util.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            int nexti;
            {
                this.nexti = index;
            }

            @Override
            public boolean hasNext() {
                return this.nexti < AImmutableVector.this.size();
            }

            @Override
            public T next() {
                return AImmutableVector.this.get(this.nexti++);
            }

            @Override
            public boolean hasPrevious() {
                return this.nexti > 0;
            }

            @Override
            public T previous() {
                return AImmutableVector.this.get(--this.nexti);
            }

            @Override
            public int nextIndex() {
                return this.nexti;
            }

            @Override
            public int previousIndex() {
                return this.nexti - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public IImmutableVector<T> subList(int fromIndex, int toIndex) {
        if (toIndex < fromIndex || fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex == toIndex) {
            return ImmutableVector.empty();
        }
        return new SubVector(this, fromIndex, toIndex);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < AImmutableVector.this.size();
            }

            @Override
            public T next() {
                return AImmutableVector.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public T peek() {
        if (this.size() > 0) {
            return (T)this.get(this.size() - 1);
        }
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return Util.toArray(this.size(), this.iterator(), array);
    }

    @Override
    public Object[] toArray() {
        return Util.toArray(this.size(), this.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this) {
            if (!Util.equals(t, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T set(int i, T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    static class SubVector<T>
    extends AImmutableVector<T> {
        final IImmutableVector<T> v;
        final int start;
        final int end;

        public SubVector(IImmutableVector<T> v, int start, int end) {
            if (v instanceof SubVector) {
                SubVector sv = (SubVector)v;
                start += sv.start;
                end += sv.start;
                v = sv.v;
            }
            this.v = v;
            this.start = start;
            this.end = end;
        }

        @Override
        public T get(int i) {
            if (this.start + i >= this.end) {
                throw new IndexOutOfBoundsException();
            }
            return (T)this.v.get(this.start + i);
        }

        @Override
        public IImmutableVector<T> with(int i, T val) {
            if (this.start + i > this.end) {
                throw new IndexOutOfBoundsException();
            }
            if (this.start + i == this.end) {
                return this.with((Object)val);
            }
            return new SubVector<T>(this.v.with(this.start + i, val), this.start, this.end);
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public IImmutableVector<T> pop() {
            if (this.end - 1 == this.start) {
                return ImmutableVector.empty();
            }
            return new SubVector<T>(this.v, this.start, this.end - 1);
        }

        @Override
        public IImmutableVector<T> with(T o) {
            return new SubVector<T>(this.v.with(this.end, o), this.start, this.end + 1);
        }
    }
}

