/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.properties;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.log4j.Logger;

@BridgeMethodsAdded
public class LayoutPreservingProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(LayoutPreservingProperties.class);
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60;
    private static final int ONE_HOUR = 60;
    private static final int TEN = 10;
    private static final DateFormat DATE_HEADER_FORMAT_INT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
    private String ENCODING = "ISO-8859-1";
    private String LS = System.getProperty("line.separator");
    private ArrayList<LogicalLine> logicalLines = new ArrayList();
    private HashMap<String, Integer> keyedPairLines = new HashMap();
    private boolean removeComments;

    public LayoutPreservingProperties() {
    }

    public LayoutPreservingProperties(Properties defaults) {
        super(defaults);
    }

    public boolean isRemoveComments() {
        return this.removeComments;
    }

    public void setRemoveComments(boolean val) {
        this.removeComments = val;
    }

    public void load(InputStream inStream) throws IOException {
        String s = this.readLines(inStream);
        byte[] ba = s.getBytes(this.ENCODING);
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        super.load(bais);
    }

    public Object put(Object key, Object value) throws NullPointerException {
        Object obj = super.put(key, value);
        this.innerSetProperty(key.toString(), value.toString());
        return obj;
    }

    public Object setProperty(String key, String value) throws NullPointerException {
        Object obj = super.setProperty(key, value);
        this.innerSetProperty(key, value);
        return obj;
    }

    private void innerSetProperty(String key, String value) {
        value = this.escapeValue(value);
        if (this.keyedPairLines.containsKey(key)) {
            Integer i = this.keyedPairLines.get(key);
            Pair p = (Pair)this.logicalLines.get(i);
            p.setValue(value);
        } else {
            key = this.escapeName(key);
            Pair p = new Pair(key, value);
            p.setNew(true);
            this.keyedPairLines.put(key, new Integer(this.logicalLines.size()));
            this.logicalLines.add(p);
        }
    }

    public void clear() {
        super.clear();
        this.keyedPairLines.clear();
        this.logicalLines.clear();
    }

    public Object remove(Object key) {
        Object obj = super.remove(key);
        Integer i = this.keyedPairLines.remove(key);
        if (null != i) {
            if (this.removeComments) {
                this.removeCommentsEndingAt(i);
            }
            this.logicalLines.set(i, null);
        }
        return obj;
    }

    public Object clone() {
        LayoutPreservingProperties dolly = (LayoutPreservingProperties)super.clone();
        dolly.keyedPairLines = (HashMap)this.keyedPairLines.clone();
        dolly.logicalLines = (ArrayList)this.logicalLines.clone();
        for (int j = 0; j < dolly.logicalLines.size(); ++j) {
            LogicalLine line = dolly.logicalLines.get(j);
            if (!(line instanceof Pair)) continue;
            Pair p = (Pair)line;
            dolly.logicalLines.set(j, (Pair)p.clone());
        }
        return dolly;
    }

    public void listLines(PrintStream out) {
        out.println("-- logical lines --");
        for (LogicalLine line : this.logicalLines) {
            if (line instanceof Blank) {
                out.println("blank:   \"" + line + "\"");
                continue;
            }
            if (line instanceof Comment) {
                out.println("comment: \"" + line + "\"");
                continue;
            }
            if (!(line instanceof Pair)) continue;
            out.println("pair:    \"" + line + "\"");
        }
    }

    public void saveAs(File dest) throws IOException {
        FileOutputStream fos = new FileOutputStream(dest);
        this.store(fos, null);
        fos.close();
    }

    public void store(OutputStream out, String header) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, this.ENCODING);
        int skipLines = 0;
        int totalLines = this.logicalLines.size();
        if (header != null) {
            osw.write("#" + header + this.LS);
            if (totalLines > 0 && this.logicalLines.get(0) instanceof Comment && header.equals(this.logicalLines.get(0).toString().substring(1))) {
                skipLines = 1;
            }
        }
        if (totalLines > skipLines && this.logicalLines.get(skipLines) instanceof Comment) {
            try {
                this.parseDateFromHeader(this.logicalLines.get(skipLines).toString().substring(1));
                ++skipLines;
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        osw.write("#" + this.getDateForHeader() + this.LS);
        boolean writtenSep = false;
        for (LogicalLine line : this.logicalLines.subList(skipLines, totalLines)) {
            if (line instanceof Pair) {
                if (((Pair)line).isNew() && !writtenSep) {
                    osw.write(this.LS);
                    writtenSep = true;
                }
                osw.write(line.toString() + this.LS);
                continue;
            }
            if (line == null) continue;
            osw.write(line.toString() + this.LS);
        }
        osw.close();
    }

    private String readLines(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is, this.ENCODING);
        PushbackReader pbr = new PushbackReader(isr, 1);
        if (this.logicalLines.size() > 0) {
            this.logicalLines.add(new Blank());
        }
        String s = this.readFirstLine(pbr);
        BufferedReader br = new BufferedReader(pbr);
        boolean continuation = false;
        boolean comment = false;
        StringBuffer fileBuffer = new StringBuffer();
        StringBuffer logicalLineBuffer = new StringBuffer();
        while (s != null) {
            fileBuffer.append(s).append(this.LS);
            if (continuation) {
                s = "\n" + s;
            } else {
                comment = s.matches("^( |\t|\f)*(#|!).*");
            }
            if (!comment) {
                continuation = this.requiresContinuation(s);
            }
            logicalLineBuffer.append(s);
            if (!continuation) {
                LogicalLine line = null;
                if (comment) {
                    line = new Comment(logicalLineBuffer.toString());
                } else if (logicalLineBuffer.toString().trim().length() == 0) {
                    line = new Blank();
                } else {
                    line = new Pair(logicalLineBuffer.toString());
                    String key = this.unescape(((Pair)line).getName());
                    if (this.keyedPairLines.containsKey(key)) {
                        this.remove(key);
                    }
                    this.keyedPairLines.put(key, new Integer(this.logicalLines.size()));
                }
                this.logicalLines.add(line);
                logicalLineBuffer.setLength(0);
            }
            s = br.readLine();
        }
        return fileBuffer.toString();
    }

    private String readFirstLine(PushbackReader r) throws IOException {
        StringBuffer sb = new StringBuffer(80);
        int ch = r.read();
        boolean hasCR = false;
        this.LS = System.getProperty("line.separator");
        while (ch >= 0) {
            if (hasCR && ch != 10) {
                r.unread(ch);
                break;
            }
            if (ch == 13) {
                this.LS = "\r";
                hasCR = true;
            } else {
                if (ch == 10) {
                    this.LS = hasCR ? "\r\n" : "\n";
                    break;
                }
                sb.append((char)ch);
            }
            ch = r.read();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseDateFromHeader(String datestr) throws ParseException {
        DateFormat dateFormat = DATE_HEADER_FORMAT_INT;
        synchronized (dateFormat) {
            return DATE_HEADER_FORMAT_INT.parse(datestr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDateForHeader() {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(cal.get(0), cal.get(1), cal.get(2), cal.get(5), cal.get(7), cal.get(14));
        StringBuffer tzMarker = new StringBuffer(offset < 0 ? "-" : "+");
        offset = Math.abs(offset);
        int hours = offset / 3600000;
        int minutes = offset / 60000 - 60 * hours;
        if (hours < 10) {
            tzMarker.append("0");
        }
        tzMarker.append(hours);
        if (minutes < 10) {
            tzMarker.append("0");
        }
        tzMarker.append(minutes);
        DateFormat dateFormat = DATE_HEADER_FORMAT_INT;
        synchronized (dateFormat) {
            return DATE_HEADER_FORMAT_INT.format(cal.getTime()) + tzMarker.toString();
        }
    }

    private boolean requiresContinuation(String s) {
        int i;
        char[] ca = s.toCharArray();
        for (i = ca.length - 1; i > 0 && ca[i] == '\\'; --i) {
        }
        int tb = ca.length - i - 1;
        return tb % 2 == 1;
    }

    private String unescape(String s) {
        char c;
        char[] ch = new char[s.length() + 1];
        s.getChars(0, s.length(), ch, 0);
        ch[s.length()] = 10;
        StringBuffer buffy = new StringBuffer(s.length());
        for (int i = 0; i < ch.length && (c = ch[i]) != '\n'; ++i) {
            if (c == '\\') {
                if ((c = ch[++i]) == 'n') {
                    buffy.append('\n');
                    continue;
                }
                if (c == 'r') {
                    buffy.append('\r');
                    continue;
                }
                if (c == 'f') {
                    buffy.append('\f');
                    continue;
                }
                if (c == 't') {
                    buffy.append('\t');
                    continue;
                }
                if (c == 'u') {
                    c = this.unescapeUnicode(ch, i + 1);
                    i += 4;
                    buffy.append(c);
                    continue;
                }
                buffy.append(c);
                continue;
            }
            buffy.append(c);
        }
        return buffy.toString();
    }

    private char unescapeUnicode(char[] ch, int i) {
        String s = new String(ch, i, 4);
        return (char)Integer.parseInt(s, 16);
    }

    private String escapeValue(String s) {
        return this.escape(s, false);
    }

    private String escapeName(String s) {
        return this.escape(s, true);
    }

    private String escape(String s, boolean escapeAllSpaces) {
        if (s == null) {
            return null;
        }
        char[] ch = new char[s.length()];
        s.getChars(0, s.length(), ch, 0);
        String forEscaping = "\t\f\r\n\\:=#!";
        String escaped = "tfrn\\:=#!";
        StringBuffer buffy = new StringBuffer(s.length());
        boolean leadingSpace = true;
        for (char c : ch) {
            int p;
            if (c == ' ') {
                if (escapeAllSpaces || leadingSpace) {
                    buffy.append("\\");
                }
            } else {
                leadingSpace = false;
            }
            if ((p = forEscaping.indexOf(c)) != -1) {
                buffy.append("\\").append(escaped.substring(p, p + 1));
                continue;
            }
            if (c < ' ' || c > '~') {
                buffy.append(this.escapeUnicode(c));
                continue;
            }
            buffy.append(c);
        }
        return buffy.toString();
    }

    private String escapeUnicode(char ch) {
        StringBuffer buffy = new StringBuffer("\\u");
        String hex = Integer.toHexString(ch);
        buffy.append("0000".substring(4 - hex.length()));
        buffy.append(hex);
        return buffy.toString();
    }

    private void removeCommentsEndingAt(int pos) {
        int end;
        for (pos = end = pos - 1; pos > 0 && this.logicalLines.get(pos) instanceof Blank; --pos) {
        }
        if (!(this.logicalLines.get(pos) instanceof Comment)) {
            return;
        }
        while (pos >= 0 && this.logicalLines.get(pos) instanceof Comment) {
            --pos;
        }
        ++pos;
        while (pos <= end) {
            this.logicalLines.set(pos, null);
            ++pos;
        }
    }

    @BridgeMethodsAdded
    private static class Pair
    extends LogicalLine
    implements Cloneable {
        private String name;
        private boolean added;

        public Pair(String text) {
            super(text);
            this.parsePair(text);
        }

        public Pair(String name, String value) {
            this(name + "=" + value);
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.setText(this.name + "=" + value);
        }

        public boolean isNew() {
            return this.added;
        }

        public void setNew(boolean val) {
            this.added = val;
        }

        public Object clone() {
            Object dolly = null;
            try {
                dolly = super.clone();
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)e, (Throwable)e);
            }
            return dolly;
        }

        private void parsePair(String text) {
            int pos = this.findFirstSeparator(text);
            this.name = pos == -1 ? text : text.substring(0, pos);
            this.name = this.stripStart(this.name, " \t\f");
        }

        private String stripStart(String s, String chars) {
            int i;
            if (s == null) {
                return null;
            }
            for (i = 0; i < s.length() && chars.indexOf(s.charAt(i)) != -1; ++i) {
            }
            if (i == s.length()) {
                return "";
            }
            return s.substring(i);
        }

        private int findFirstSeparator(String s) {
            s = s.replaceAll("\\\\\\\\", "__");
            s = s.replaceAll("\\\\=", "__");
            s = s.replaceAll("\\\\:", "__");
            s = s.replaceAll("\\\\ ", "__");
            s = s.replaceAll("\\\\t", "__");
            return this.indexOfAny(s, " :=\t");
        }

        private int indexOfAny(String s, String chars) {
            if (s == null || chars == null) {
                return -1;
            }
            int p = s.length() + 1;
            for (int i = 0; i < chars.length(); ++i) {
                int x = s.indexOf(chars.charAt(i));
                if (x == -1 || x >= p) continue;
                p = x;
            }
            if (p == s.length() + 1) {
                return -1;
            }
            return p;
        }
    }

    @BridgeMethodsAdded
    private class Comment
    extends LogicalLine {
        public Comment(String text) {
            super(text);
        }
    }

    @BridgeMethodsAdded
    private static class Blank
    extends LogicalLine {
        public Blank() {
            super("");
        }
    }

    @BridgeMethodsAdded
    private static abstract class LogicalLine {
        private String text;

        public LogicalLine(String text) {
            this.text = text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

