/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class StoredX509Cert
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final X509Certificate[] chain;
    private final String authType;

    public StoredX509Cert(X509Certificate[] chain, String authType) {
        this.chain = chain;
        this.authType = authType;
    }

    public X509Certificate[] getChain() {
        return this.chain;
    }

    public String getAuthType() {
        return this.authType;
    }

    public List<String> extractNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (X509Certificate cert : this.chain) {
            String certName = "null";
            if (cert != null) {
                String name;
                String subjectDnName = "<unknown>";
                Principal subjectDN = cert.getSubjectDN();
                if (subjectDN != null && (name = subjectDN.getName()) != null) {
                    subjectDnName = name;
                }
                certName = subjectDnName;
            }
            result.add(certName);
        }
        return result;
    }

    public int hashCode() {
        int hashCode = 0;
        for (X509Certificate certInChain : this.getChain()) {
            hashCode += certInChain.hashCode();
        }
        return hashCode += 3 * this.authType.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof StoredX509Cert) {
            StoredX509Cert cert = (StoredX509Cert)obj;
            isEqual = this.hashCode() == cert.hashCode();
        }
        return isEqual;
    }
}

