/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.process.unix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvParser {
    private static String SEP = System.getProperty("line.separator");
    private Map<String, String> environment;
    private BufferedReader reader;

    public EnvParser(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public EnvParser(Reader in) {
        this.reader = new BufferedReader(in);
    }

    public synchronized Map<String, String> getEnvironment() throws IOException {
        if (this.environment == null) {
            this.readEnvOutput();
        }
        return this.environment;
    }

    protected void readEnvOutput() throws IOException {
        String line;
        HashMap<String, String> environment = new HashMap<String, String>();
        String name = null;
        String value = null;
        while ((line = this.reader.readLine()) != null) {
            int index = line.indexOf(61);
            if (index > 0) {
                if (name != null) {
                    environment.put(name, value);
                }
                name = line.substring(0, index);
                value = line.substring(index + 1);
            }
            if (index > 0 && name != null && name.length() != 0) continue;
            if (value == null) {
                value = SEP + line;
                continue;
            }
            value = value + SEP + line;
        }
        if (name != null) {
            environment.put(name, value);
        }
        this.environment = Collections.unmodifiableMap(environment);
    }
}

