/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugin.rqm

public class RQMHelper {

    final static String EXIT_ON_COMPLETE = "-exitOnComplete=true";
    final static String PRINT_RESULT_URL = "-printResultUrl=true";

    /**
     * @param arguments String containing RQM's additional arguments
     * @return String containing '-exitOnComplete=true' or -'printResultUrl=true' if missing
     */
    public static String setRequiredArguments(String arguments) {
        String result = arguments;

        // Add '-exitOnComplete=true' if missing
        if (!arguments.split(" ").contains(EXIT_ON_COMPLETE)){
            if (arguments) {
                result += " " + EXIT_ON_COMPLETE;
            } else {
                result = EXIT_ON_COMPLETE;
            }
        }

        // Add '-printResultUrl=true' if missing
        if (!arguments.split(" ").contains(PRINT_RESULT_URL)){
            result += " " + PRINT_RESULT_URL;
        }
        return result;
    }
}
