/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.bmc.arsys.api.*;
import java.util.*;
import java.lang.*;

import com.urbancode.air.plugin.remedy.TextAreaHelper;

def chgId = props['entryId'];
def user = props['user'];
def password = props['password'];
def server = props['server']
def port = Integer.valueOf(props['port']);
def form = props['form'];
def fieldValues = props['fieldValues'];

ARServerUser arUser = new ARServerUser(user, password, "", "", server, port);
arUser.login()
println "Connected to ${server} as user ${user}";

def fields = arUser.getListFieldObjects(form);

def fieldMap = [:];
def fieldTypes = [:];
fields.each { it ->
   fieldMap[it.name] = it.fieldID;
   fieldTypes[it.name] = it.fieldLimit;
}

def fieldValueList = fieldValues.split("\n");
int [] fieldIds = new int[fieldValueList.size()];
def expectedValues = new String[fieldValueList.size()];
def fieldNames = new String[fieldValueList.size()];
fieldValueList.eachWithIndex() { fieldValueString,idx ->
    if (fieldValueString != null && fieldValueString.trim().length() != 0) {
        String[] fieldValueSplit = TextAreaHelper.splitFieldValuePair(fieldValueString);
        def fieldName = fieldValueSplit[0];
        def fieldValue = fieldValueSplit[1];
        fieldIds[idx] = fieldMap[fieldName];
        expectedValues[idx] = fieldValue;
        fieldNames[idx] = fieldName;
    }
}

def entry = arUser.getEntry(form, chgId, fieldIds);

def wrongValues = [];
fieldIds.eachWithIndex() { it, idx ->
    def fieldName = fieldNames[idx];
    def expectedValue = expectedValues[idx];
    def actualValue = entry.get(it);

    if (fieldTypes[fieldName] == null) {
        throw new Exception("Field ${fieldName} does not exist in form ${form}");
    }
    if (fieldTypes[fieldName] instanceof IntegerFieldLimit) {
        expectedValue = Integer.valueOf(expectedValue);
        expectedValue = new Value(expectedValue);
    }
    else if (fieldTypes[fieldName] instanceof RealFieldLimit) {
        expectedValue = Double.valueOf(expectedValue);
        expectedValue = new Value(expectedValue);
    }
    else if (fieldTypes[fieldName] instanceof SelectionFieldLimit) {
        def enumItems = fieldTypes[fieldName].getValues();
        def enumValue = expectedValue;
        expectedValue = enumItems.find { enumIt -> enumIt.enumItemName.equals(enumValue)}?.enumItemNumber;
        expectedValue = new Value(String.valueOf(expectedValue), DataType.ENUM);
    }
    else {
        expectedValue = new Value(expectedValue);
    }

    if (actualValue != expectedValue) {
        wrongValues << "Value for ${fieldName} is wrong! \"${expectedValue}\" != \"${actualValue}\"";
    }
}

if (wrongValues.size() > 0) {
    wrongValues.each {
        println it;
    }
    throw new RuntimeException("Wrong values encountered, step failed");
}
