/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.bmc.arsys.api.*;
import java.util.*;
import java.lang.*;

import com.urbancode.air.plugin.remedy.TextAreaHelper;

def user = props['user'];
def password = props['password'];
def server = props['server']
def port = Integer.valueOf(props['port']);
def form = props['form'];
def fieldValues = props['fieldValues'];

ARServerUser arUser = new ARServerUser(user, password, "", "", server, port);
arUser.login()
println "Connected to ${server} as user ${user}";

def fields = arUser.getListFieldObjects(form);

def fieldMap = [:];
def fieldTypes = [:];
fields.each { it ->
   fieldMap[it.name] = it.fieldID;
   fieldTypes[it.name] = it.fieldLimit;
}

Entry entry = new Entry();
def fieldValueList = fieldValues.split('\n');
fieldValueList.each { fieldValueString ->
    if (fieldValueString != null && fieldValueString.trim().length() != 0) {
        String[] fieldValueSplit = TextAreaHelper.splitFieldValuePair(fieldValueString);
        def fieldName = fieldValueSplit[0];
        def fieldValue = fieldValueSplit[1];

        if (fieldTypes[fieldName] == null) {
            throw new Exception("Field ${fieldName} does not exist in form ${form}");
        }

        if (fieldTypes[fieldName] instanceof IntegerFieldLimit) {
            fieldValue = Integer.valueOf(fieldValue);
        }
        else if (fieldTypes[fieldName] instanceof RealFieldLimit) {
            fieldValue = Double.valueOf(fieldValue);
        }
        else if (fieldTypes[fieldName] instanceof SelectionFieldLimit) {
            def enumItems = fieldTypes[fieldName].getValues();
            def enumValue = fieldValue;
            fieldValue = enumItems.find { enumIt -> enumIt.enumItemName.equals(enumValue)}?.enumItemNumber;
        }

        println "${fieldName} -> ${fieldTypes[fieldName].class.name} : ${fieldValue} -> ${fieldValue.class.name}"
        entry.put(fieldMap[fieldName], new Value(fieldValue));
    }
}

def id = arUser.createEntry(form, entry);
outProps.setProperty("entryId", id);
