#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import groovy.io.FileType;
import groovy.util.GroovyScriptEngine;
import com.urbancode.air.AirPluginTool;


final def workDir = new File('.').canonicalFile
final def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def pluginStepScript = new File(args[2]);
final def props = apTool.getStepProperties();
final def outProps = new Properties();

Binding binding = new Binding();
binding.setVariable("outProps", apTool.outProps);
binding.setVariable("props", props);

// Recursively Add jars to class loader
def jarFolder = props['jarFolder'];
File jarDirectory = new File(jarFolder);
jarDirectory.traverse(
    type        : FileType.FILES,
    nameFilter  : ~/.*.jar/
) {File jarFile ->
    println jarFile.toString();
    this.class.classLoader.rootLoader.addURL(jarFile.toURI().toURL());
}

GroovyShell shell = new GroovyShell(this.class.classLoader.rootLoader, binding);
try {
    shell.evaluate(pluginStepScript);
}
finally {
    apTool.storeOutputProperties();
}
