#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.ibm.urbancode.zos.jes.passticket.PassTicketUtil;
import com.urbancode.air.AirPluginTool;

final def workDir = new File('.').canonicalFile;
def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

final def appID = props['appID'].trim();
final def autocommit = props['autocommit'].trim();
final def connectionString = props['connectionString'].trim();
final def delimiter = props['delimiter'];
final def excludes = props['excludes'].trim();
final def files = props['files'].trim();
final def includes = props['includes'].trim();
final def irrracfLibraryPath = props['irrracfLibraryPath'].trim();
final def jdbcDriver = props['jdbcDriver'].trim();
final def onerror = props['onerror'].trim();
final def print = props['print'].trim();
final def username = props['username'];

def password = PassTicketUtil.generatePassTicket(username, appID, irrracfLibraryPath);
println "PassTicket generated."

try {
    def ant = new AntBuilder()

    ant.sql(
            driver:jdbcDriver,
            url:connectionString,
            userid:username,
            'password':password,
            'delimiter':delimiter,
            'autocommit':autocommit,
            'print':print,
            'onerror':onerror
    ) {
        if (files != null && files.trim() != "") {
            filelist(
                    dir:'.',
                    'files':files
            )
        }
        else {
            if (excludes) {
                fileset(
                        dir: '.',
                        defaultexcludes: 'no',
                        'includes': includes.split('\n').join(','),
                        'excludes': excludes.split('\n').join(',')
                )
            }
            else {
                fileset(
                        dir: '.',
                        defaultexcludes: 'no',
                        'includes': includes.split('\n').join(',')
                )
            }
        }
    }
}
catch (Exception e) {
    println "Error Executing SQL Scripts: ${e.message}"
    System.exit(1)

}

System.exit(0)
