/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool;

def workDir = new File('.').canonicalFile
AirPluginTool apt = new AirPluginTool(args[0], args[1]);

final def props = apt.getStepProperties();

def dirOffset = props['dirOffset']
def sqlCmdPath = props['sqlCmdPath']
def server = props['server']
def user = props['user']
def password = props['password']
def passwordScript = props['passwordScript']
def trustedConnection = Boolean.valueOf(props['trustedConnection'])
def adminConnection = Boolean.valueOf(props['adminConnection'])
def dbName = props['dbName']
def sqlFileIncludes = props['sqlFileIncludes']
def sqlFiles = props['sqlFiles']
def sqlFilesExcludes = props['sqlFilesExcludes']
def connTimeout = props['connTimeout']

def additionalArgs = []
def additionalArgsStr = props['additionalArgs']?.trim()
if (additionalArgsStr) {

    // Split each Additional Args by newline or comma, then remove any empty arrays
    def tempArgs = additionalArgsStr.split(",|\n")*.trim() - [""]

    // Iterate through each arg and separate FLAG from VALUE
    for (int i = 0; i < tempArgs.size(); i++) {
        additionalArgs.addAll(tempArgs[i].split(" ", 2)*.trim())
    }

}

if (dirOffset) {
    workDir = new File(workDir, dirOffset).canonicalFile
}

def runSQLCmd = { file ->
    def cmdArgs = [(sqlCmdPath?sqlCmdPath:'') + 'sqlcmd']

    // Enable exit codes to be non-zero when errors occur
    cmdArgs << '-b'

    if (server) {
        cmdArgs << '-S'
        cmdArgs << server
    }
    if (user) {
        cmdArgs << '-U'
        cmdArgs << user
    }
    if (password || passwordScript) {
        cmdArgs << '-P'
        cmdArgs << (password?password:passwordScript)
    }
    if (trustedConnection) {
        cmdArgs << '-E'
    }
    if (adminConnection) {
        cmdArgs << '-A'
    }
    if (dbName) {
        cmdArgs << '-d'
        cmdArgs << dbName
    }
    if (connTimeout) {
        cmdArgs << '-l'
        cmdArgs << connTimeout
    }

    cmdArgs.addAll(additionalArgs)

    cmdArgs << '-i'
    cmdArgs << file.canonicalPath

    System.out.println("Executing : " + cmdArgs.join(' '));

    def proc = cmdArgs.execute(null, workDir);
    proc.waitForProcessOutput(System.out, System.out);
    proc.waitFor();
    if (proc.exitValue() != 0) {
        System.exit proc.exitValue()
    }
}

//ensure only includes or files was set
if (sqlFiles != null && sqlFiles.trim() != "" && sqlFileIncludes != null && sqlFileIncludes.trim() != "") {
    throw new IllegalArgumentException("Please Specify only Sql Files or Sql Files Includes not both!");
}

println "Working directory: ${workDir.canonicalPath}"
if (sqlFiles == null || sqlFiles.trim() == "") {
    println "Include Files: ${sqlFileIncludes.split('\n').join(' ')}"
    println "Exclude Files: ${sqlFilesExcludes?.split('\n')?.join(' ')}"
}
else {
    println "SQLFiles: ${sqlFiles?.split('\n')?.join(' ')}"
}

if (workDir.isFile()) {
    throw new IllegalArgumentException("Working directory ${workDir} is a file!")
}

if (sqlCmdPath && !sqlCmdPath.endsWith(File.separator)) {
    sqlCmdPath += File.separator
}

// find scripts to run

if (sqlFiles == null || sqlFiles.trim() == "") {
    def ant = new AntBuilder()

    scanner = ant.fileScanner {
        if (sqlFilesExcludes && sqlFilesExcludes.trim().length() > 0) {
            fileset(dir:"${workDir.canonicalPath}", includes:"${sqlFileIncludes.split('\n').join(' ')}", excludes: "${sqlFilesExcludes?.split('\n')?.join(' ')}")
        }
        else {
            fileset(dir:"${workDir.canonicalPath}", includes:"${sqlFileIncludes.split('\n').join(' ')}")
        }
    }

    if (!scanner.hasFiles()) {
        println "Did not find any files matching \"${sqlFileIncludes.split('\n').join(' ')}\" except \"${sqlFilesExcludes?.split('\n')?.join(' ')}\" in ${workDir.canonicalPath}!"
    }

    def results = []

    for (file in scanner) {
        results << file
    }

    if (results.isEmpty()) {
        println "Did not find any files matching \"${sqlFileIncludes.split('\n').join(' ')}\" except \"${sqlFilesExcludes?.split('\n')?.join(' ')}\" in ${workDir.canonicalPath}!"
    }

// now lets iterate over the scripts and execute them
    results.sort().each { file ->
        runSQLCmd(file);
    }
}
else {
    sqlFiles.split('\n').each { file ->
        runSQLCmd(new File(file));
    }
}

System.exit 0
