/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.urbancode.commons.util.immutable.AImmutableMap;
import com.urbancode.commons.util.immutable.ArraySeq;
import com.urbancode.commons.util.immutable.Box;
import com.urbancode.commons.util.immutable.IImmutableMap;
import com.urbancode.commons.util.immutable.ISeq;
import com.urbancode.commons.util.immutable.Util;
import java.util.Map;

public class ImmutableHashMap<K, V>
extends AImmutableMap<K, V> {
    final int count;
    final INode<K, V> root;
    private static final EmptyNode<Object, Object> EMPTY_NODE = new EmptyNode();
    private static final ImmutableHashMap<?, ?> EMPTY = new ImmutableHashMap<Object, Object>(0, EMPTY_NODE);

    public static <K, V> ImmutableHashMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> ImmutableHashMap<K, V> create(Map<? extends K, ? extends V> other) {
        IImmutableMap<K, V> ret = ImmutableHashMap.empty();
        for (Map.Entry<K, V> o : other.entrySet()) {
            ret = ret.with((Object)o.getKey(), (Object)o.getValue());
        }
        return ret;
    }

    private ImmutableHashMap(int count, INode<K, V> root) {
        this.count = count;
        this.root = root;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entryAt(key) != null;
    }

    @Override
    protected Map.Entry<K, V> entryAt(Object key) {
        return this.root.find(Util.hash(key), key);
    }

    @Override
    public ImmutableHashMap<K, V> with(K key, V val) {
        Box addedLeaf = new Box(null);
        INode<K, V> newroot = this.root.with(0, Util.hash(key), key, val, addedLeaf);
        if (newroot == this.root) {
            return this;
        }
        return new ImmutableHashMap<K, V>(addedLeaf.val == null ? this.count : this.count + 1, newroot);
    }

    @Override
    public V get(Object key, V notFound) {
        Map.Entry<K, V> e = this.entryAt(key);
        if (e != null) {
            return e.getValue();
        }
        return notFound;
    }

    @Override
    public V get(Object key) {
        return this.get(key, null);
    }

    @Override
    public ImmutableHashMap<K, V> without(Object key) {
        INode<K, V> newroot = this.root.without(Util.hash(key), key);
        if (newroot == this.root) {
            return this;
        }
        if (newroot == null) {
            return ImmutableHashMap.empty();
        }
        return new ImmutableHashMap<K, V>(this.count - 1, newroot);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    protected ISeq<Map.Entry<K, V>> seq() {
        return this.root.nodeSeq();
    }

    static int mask(int hash, int shift) {
        return hash >>> shift & 0x1F;
    }

    static final class HashCollisionNode<K, V>
    implements INode<K, V> {
        final int hash;
        final LeafNode<K, V>[] leaves;

        public HashCollisionNode(int hash, LeafNode<K, V> ... leaves) {
            this.hash = hash;
            this.leaves = leaves;
        }

        public HashCollisionNode(int hash, LeafNode<K, V> leaf) {
            this.hash = hash;
            this.leaves = new LeafNode[]{leaf};
        }

        @Override
        public INode<K, V> with(int shift, int hash, K key, V val, Box addedLeaf) {
            if (hash == this.hash) {
                int idx = this.findIndex(hash, key);
                if (idx != -1) {
                    if (this.leaves[idx].val == val) {
                        return this;
                    }
                    LeafNode[] newLeaves = (LeafNode[])this.leaves.clone();
                    newLeaves[idx] = new LeafNode<K, V>(hash, key, val);
                    return new HashCollisionNode<K, V>(hash, newLeaves);
                }
                LeafNode[] newLeaves = new LeafNode[this.leaves.length + 1];
                System.arraycopy(this.leaves, 0, newLeaves, 0, this.leaves.length);
                LeafNode<K, V> leafNode = new LeafNode<K, V>(hash, key, val);
                newLeaves[this.leaves.length] = leafNode;
                addedLeaf.val = leafNode;
                return new HashCollisionNode<K, V>(hash, newLeaves);
            }
            return BitmapIndexedNode.create(shift, this, hash, key, val, addedLeaf);
        }

        @Override
        public INode<K, V> without(int hash, Object key) {
            int idx = this.findIndex(hash, key);
            if (idx == -1) {
                return this;
            }
            if (this.leaves.length == 2) {
                return idx == 0 ? this.leaves[1] : this.leaves[0];
            }
            LeafNode[] newLeaves = new LeafNode[this.leaves.length - 1];
            System.arraycopy(this.leaves, 0, newLeaves, 0, idx);
            System.arraycopy(this.leaves, idx + 1, newLeaves, idx, this.leaves.length - (idx + 1));
            return new HashCollisionNode<K, V>(hash, newLeaves);
        }

        @Override
        public LeafNode<K, V> find(int hash, Object key) {
            int idx = this.findIndex(hash, key);
            if (idx != -1) {
                return this.leaves[idx];
            }
            return null;
        }

        @Override
        public ISeq<Map.Entry<K, V>> nodeSeq() {
            return ArraySeq.create(this.leaves);
        }

        int findIndex(int hash, Object key) {
            for (int i = 0; i < this.leaves.length; ++i) {
                if (this.leaves[i].find(hash, key) == null) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getHash() {
            return this.hash;
        }
    }

    static final class LeafNode<K, V>
    implements Map.Entry<K, V>,
    INode<K, V> {
        final int hash;
        final K key;
        final V val;

        public LeafNode(int hash, K key, V val) {
            this.hash = hash;
            this.key = key;
            this.val = val;
        }

        @Override
        public INode<K, V> with(int shift, int hash, K key, V val, Box addedLeaf) {
            if (hash == this.hash) {
                LeafNode<K, V> newLeaf;
                if (Util.equals(key, this.key)) {
                    if (val == this.val) {
                        return this;
                    }
                    return new LeafNode<K, V>(hash, key, val);
                }
                addedLeaf.val = newLeaf = new LeafNode<K, V>(hash, key, val);
                return new HashCollisionNode(hash, this, newLeaf);
            }
            return BitmapIndexedNode.create(shift, this, hash, key, val, addedLeaf);
        }

        @Override
        public INode<K, V> without(int hash, Object key) {
            if (hash == this.hash && Util.equals(key, this.key)) {
                return null;
            }
            return this;
        }

        @Override
        public LeafNode<K, V> find(int hash, Object key) {
            if (hash == this.hash && Util.equals(key, this.key)) {
                return this;
            }
            return null;
        }

        @Override
        public ISeq<Map.Entry<K, V>> nodeSeq() {
            return new ISeq<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> first() {
                    return LeafNode.this;
                }

                @Override
                public ISeq<Map.Entry<K, V>> next() {
                    return null;
                }
            };
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        public K key() {
            return this.key;
        }

        public V val() {
            return this.val;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        public void setKey(K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class BitmapIndexedNode<K, V>
    implements INode<K, V> {
        final int bitmap;
        final INode<K, V>[] nodes;
        final int shift;
        final int _hash;

        static int bitpos(int hash, int shift) {
            return 1 << ImmutableHashMap.mask(hash, shift);
        }

        final int index(int bit) {
            return Integer.bitCount(this.bitmap & bit - 1);
        }

        BitmapIndexedNode(int bitmap, INode<K, V>[] nodes, int shift) {
            this.bitmap = bitmap;
            this.nodes = nodes;
            this.shift = shift;
            this._hash = nodes[0].getHash();
        }

        static <K, V> INode<K, V> create(int bitmap, INode<K, V>[] nodes, int shift) {
            if (bitmap == -1) {
                return new FullNode<K, V>(nodes, shift);
            }
            return new BitmapIndexedNode<K, V>(bitmap, nodes, shift);
        }

        static <K, V> INode<K, V> create(int shift, INode<K, V> branch, int hash, K key, V val, Box addedLeaf) {
            int position = BitmapIndexedNode.bitpos(branch.getHash(), shift);
            BitmapIndexedNode<K, V> node = new BitmapIndexedNode<K, V>(position, new INode[]{branch}, shift);
            return node.with(shift, hash, key, val, addedLeaf);
        }

        @Override
        public INode<K, V> with(int levelShift, int hash, K key, V val, Box addedLeaf) {
            int bit = BitmapIndexedNode.bitpos(hash, this.shift);
            int idx = this.index(bit);
            if ((this.bitmap & bit) != 0) {
                INode<K, V> n = this.nodes[idx].with(this.shift + 5, hash, key, val, addedLeaf);
                if (n == this.nodes[idx]) {
                    return this;
                }
                INode[] newnodes = (INode[])this.nodes.clone();
                newnodes[idx] = n;
                return new BitmapIndexedNode<K, V>(this.bitmap, newnodes, this.shift);
            }
            INode[] newnodes = new INode[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, newnodes, 0, idx);
            addedLeaf.val = newnodes[idx] = new LeafNode<K, V>(hash, key, val);
            System.arraycopy(this.nodes, idx, newnodes, idx + 1, this.nodes.length - idx);
            return BitmapIndexedNode.create(this.bitmap | bit, newnodes, this.shift);
        }

        @Override
        public INode<K, V> without(int hash, Object key) {
            int idx;
            INode<K, V> n;
            int bit = BitmapIndexedNode.bitpos(hash, this.shift);
            if ((this.bitmap & bit) != 0 && (n = this.nodes[idx = this.index(bit)].without(hash, key)) != this.nodes[idx]) {
                if (n == null) {
                    if (this.bitmap == bit) {
                        return null;
                    }
                    INode[] newnodes = new INode[this.nodes.length - 1];
                    System.arraycopy(this.nodes, 0, newnodes, 0, idx);
                    System.arraycopy(this.nodes, idx + 1, newnodes, idx, this.nodes.length - (idx + 1));
                    return new BitmapIndexedNode<K, V>(this.bitmap & ~bit, newnodes, this.shift);
                }
                INode[] newnodes = (INode[])this.nodes.clone();
                newnodes[idx] = n;
                return new BitmapIndexedNode<K, V>(this.bitmap, newnodes, this.shift);
            }
            return this;
        }

        @Override
        public LeafNode<K, V> find(int hash, Object key) {
            int bit = BitmapIndexedNode.bitpos(hash, this.shift);
            if ((this.bitmap & bit) != 0) {
                return this.nodes[this.index(bit)].find(hash, key);
            }
            return null;
        }

        @Override
        public int getHash() {
            return this._hash;
        }

        @Override
        public ISeq<Map.Entry<K, V>> nodeSeq() {
            return Seq.create(this, 0);
        }

        static class Seq<K, V>
        implements ISeq<Map.Entry<K, V>> {
            final ISeq<? extends Map.Entry<K, V>> s;
            final int i;
            final BitmapIndexedNode<K, V> node;

            Seq(ISeq<? extends Map.Entry<K, V>> s, int i, BitmapIndexedNode<K, V> node) {
                this.s = s;
                this.i = i;
                this.node = node;
            }

            static <K, V> ISeq<Map.Entry<K, V>> create(BitmapIndexedNode<K, V> node, int i) {
                if (i >= node.nodes.length) {
                    return null;
                }
                return new Seq(node.nodes[i].nodeSeq(), i, node);
            }

            @Override
            public Map.Entry<K, V> first() {
                return this.s.first();
            }

            @Override
            public ISeq<Map.Entry<K, V>> next() {
                ISeq<? extends Map.Entry<K, V>> nexts = this.s.next();
                if (nexts != null) {
                    return new Seq<K, V>(nexts, this.i, this.node);
                }
                return Seq.create(this.node, this.i + 1);
            }
        }
    }

    static final class FullNode<K, V>
    implements INode<K, V> {
        final INode<K, V>[] nodes;
        final int shift;
        final int _hash;

        static int bitpos(int hash, int shift) {
            return 1 << ImmutableHashMap.mask(hash, shift);
        }

        FullNode(INode<K, V>[] nodes, int shift) {
            this.nodes = nodes;
            this.shift = shift;
            this._hash = nodes[0].getHash();
        }

        @Override
        public INode<K, V> with(int levelShift, int hash, K key, V val, Box addedLeaf) {
            int idx = ImmutableHashMap.mask(hash, this.shift);
            INode<K, V> n = this.nodes[idx].with(this.shift + 5, hash, key, val, addedLeaf);
            if (n == this.nodes[idx]) {
                return this;
            }
            INode[] newnodes = (INode[])this.nodes.clone();
            newnodes[idx] = n;
            return new FullNode<K, V>(newnodes, this.shift);
        }

        @Override
        public INode<K, V> without(int hash, Object key) {
            int idx = ImmutableHashMap.mask(hash, this.shift);
            INode<K, V> n = this.nodes[idx].without(hash, key);
            if (n != this.nodes[idx]) {
                if (n == null) {
                    INode[] newnodes = new INode[this.nodes.length - 1];
                    System.arraycopy(this.nodes, 0, newnodes, 0, idx);
                    System.arraycopy(this.nodes, idx + 1, newnodes, idx, this.nodes.length - (idx + 1));
                    return new BitmapIndexedNode(~FullNode.bitpos(hash, this.shift), newnodes, this.shift);
                }
                INode[] newnodes = (INode[])this.nodes.clone();
                newnodes[idx] = n;
                return new FullNode<K, V>(newnodes, this.shift);
            }
            return this;
        }

        @Override
        public LeafNode<K, V> find(int hash, Object key) {
            return this.nodes[ImmutableHashMap.mask(hash, this.shift)].find(hash, key);
        }

        @Override
        public ISeq<Map.Entry<K, V>> nodeSeq() {
            return Seq.create(this, 0);
        }

        @Override
        public int getHash() {
            return this._hash;
        }

        static class Seq<K, V>
        implements ISeq<Map.Entry<K, V>> {
            final ISeq<? extends Map.Entry<K, V>> s;
            final int i;
            final FullNode<K, V> node;

            Seq(ISeq<? extends Map.Entry<K, V>> s, int i, FullNode<K, V> node) {
                this.s = s;
                this.i = i;
                this.node = node;
            }

            static <K, V> ISeq<Map.Entry<K, V>> create(FullNode<K, V> node, int i) {
                if (i >= node.nodes.length) {
                    return null;
                }
                return new Seq(node.nodes[i].nodeSeq(), i, node);
            }

            @Override
            public Map.Entry<K, V> first() {
                return this.s.first();
            }

            @Override
            public ISeq<Map.Entry<K, V>> next() {
                ISeq<? extends Map.Entry<K, V>> nexts = this.s.next();
                if (nexts != null) {
                    return new Seq<K, V>(nexts, this.i, this.node);
                }
                return Seq.create(this.node, this.i + 1);
            }
        }
    }

    static final class EmptyNode<K, V>
    implements INode<K, V> {
        EmptyNode() {
        }

        @Override
        public INode<K, V> with(int shift, int hash, K key, V val, Box addedLeaf) {
            LeafNode<K, V> ret;
            addedLeaf.val = ret = new LeafNode<K, V>(hash, key, val);
            return ret;
        }

        @Override
        public INode<K, V> without(int hash, Object key) {
            return this;
        }

        @Override
        public LeafNode<K, V> find(int hash, Object key) {
            return null;
        }

        @Override
        public ISeq<Map.Entry<K, V>> nodeSeq() {
            return null;
        }

        @Override
        public int getHash() {
            return 0;
        }
    }

    static interface INode<K, V> {
        public INode<K, V> with(int var1, int var2, K var3, V var4, Box var5);

        public INode<K, V> without(int var1, Object var2);

        public LeafNode<K, V> find(int var1, Object var2);

        public ISeq<Map.Entry<K, V>> nodeSeq();

        public int getHash();
    }
}

