/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.ibm.urbancode.zos.deploy.common.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class RollbackManifestParser {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CONTAINER_TYPE_PDS_VALUE = "PDS";
    private static final String CONTAINER_TYPE_SEQ_VALUE = "sequential";
    private static final String CREATED_TAG = "created";
    private static final String UPDATED_TAG = "updated";
    private static final String DELETED_TAG = "deleted";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String MISSING_ATTRIBUTE = "missing";

    public static HashMap<String, Set<DataSet>> parseDataFromRollbackXml(InputStream rollbackInputStream) throws XMLStreamException {
        LinkedHashMap<String, DataSet> datasetMap = new LinkedHashMap<String, DataSet>();
        HashMap<String, Set<DataSet>> parsedRollbackDataMap = new HashMap<String, Set<DataSet>>();
        HashSet containers = new LinkedHashSet<DataSet>();
        DataSet container = null;
        String parsedRollbackDataMapKey = null;
        boolean isInsideActionTag = false;
        boolean isInsidePDSContainer = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4RollbackXml = inputFactory.createXMLEventReader(rollbackInputStream, "CP037");
        block4: while (eventReader4RollbackXml.hasNext()) {
            XMLEvent shipListReaderEvent = eventReader4RollbackXml.nextEvent();
            switch (shipListReaderEvent.getEventType()) {
                case 1: {
                    StartElement startElement = shipListReaderEvent.asStartElement();
                    String nodeName = startElement.getName().getLocalPart().trim();
                    if (RollbackManifestParser.isActionTag(nodeName)) {
                        isInsideActionTag = true;
                        parsedRollbackDataMapKey = nodeName;
                        break;
                    }
                    if (!isInsideActionTag) break;
                    if (CONTAINER_TAG.equalsIgnoreCase(nodeName)) {
                        String containerType = XmlHelper.getAttributeValue(startElement, TYPE_ATTRIBUTE);
                        String containerName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
                        if (containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
                            isInsidePDSContainer = true;
                            container = datasetMap.getOrDefault(containerName, new DataSet(containerName));
                            container.setType(containerType);
                            break;
                        }
                        isInsidePDSContainer = false;
                        if (!containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQ_VALUE)) continue block4;
                        container = new DataSet(containerName);
                        container.setType(containerType);
                        containers.add(container);
                        break;
                    }
                    if (!RESOURCE_TAG.equalsIgnoreCase(nodeName) || !isInsidePDSContainer) break;
                    String resourceName = XmlHelper.getAttributeValue(startElement, NAME_ATTRIBUTE);
                    Member resource = new Member(resourceName);
                    String missingValue = XmlHelper.getAttributeValue(startElement, MISSING_ATTRIBUTE);
                    if (Boolean.parseBoolean(missingValue)) {
                        resource.setMissing();
                    }
                    container.addMember(resource);
                    break;
                }
                case 2: {
                    EndElement endElement = shipListReaderEvent.asEndElement();
                    String endNodeName = endElement.getName().getLocalPart().trim();
                    if (RollbackManifestParser.isActionTag(endNodeName)) {
                        parsedRollbackDataMap.put(parsedRollbackDataMapKey, containers);
                        parsedRollbackDataMapKey = null;
                        isInsideActionTag = false;
                        isInsidePDSContainer = false;
                        datasetMap = new LinkedHashMap();
                        containers = new HashSet();
                        container = null;
                        break;
                    }
                    if (!CONTAINER_TAG.equalsIgnoreCase(endNodeName)) break;
                    if (isInsidePDSContainer) {
                        containers.add(container);
                        datasetMap.put(container.getName(), container);
                        isInsidePDSContainer = false;
                    }
                    container = null;
                    break;
                }
            }
        }
        return parsedRollbackDataMap;
    }

    private static boolean isActionTag(String nodeName) {
        return CREATED_TAG.equalsIgnoreCase(nodeName) || UPDATED_TAG.equalsIgnoreCase(nodeName) || DELETED_TAG.equalsIgnoreCase(nodeName);
    }
}

