/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.salesforce.SalesForceHelper

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

String password = props['password']
String username = props['username']
String serverUrl = props['serverUrl']
String apiVersion = props['apiVersion']
String metadataType = props['metadataType']
String folder = props['folder']
String resultFilePath = props['resultFilePath']
String trace = props['trace']

def helper = new SalesForceHelper(props)
AntBuilder ant = helper.buildAnt()

println("[ACTION] Listing ${metadataType} metadata...")

ant.taskdef name: "sfListMetadata", classname: "com.salesforce.ant.ListMetadataTask"
if (resultFilePath) {
    ant.sfListMetadata(
            username: username,
            password: password,
            serverurl: serverUrl,
            apiVersion: apiVersion,
            trace: trace,
            metadataType: metadataType,
            folder: folder,
            resultFilePath: resultFilePath
    )
}
else {
    ant.sfListMetadata(
            username: username,
            password: password,
            serverurl: serverUrl,
            apiVersion: apiVersion,
            trace: trace,
            metadataType: metadataType,
            folder: folder
    )
}