/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.salesforce.SalesForceHelper

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

String containingFolder = props['containingFolder']
String password = props['password']
String username = props['username']
String serverUrl = props['serverUrl']
String metadataType = props['metadataType']
String retrieveTarget = props['retrieveTarget']
String batchSize = props['batchSize']
String apiVersion = props['apiVersion']
String maxPoll = props['maxPoll']?:"200"
String pollWaitMillis = props['pollWaitMillis']?:"10000"
String unzip = props['unzip']

def helper = new SalesForceHelper(props)
AntBuilder ant = helper.buildAnt()

println("[ACTION] Bulk retrieving ${metadataType} metadata from ${retrieveTarget}...")

ant.taskdef name: "sfBulkRetrieve", classname: "com.salesforce.ant.BulkRetrieveTask"

if (containingFolder != "") {
    ant.sfBulkRetrieve(
            username: username,
            retrieveTarget: retrieveTarget,
            metadataType: metadataType,
            password: password,
            serverurl: serverUrl,
            batchSize: batchSize,
            maxPoll: maxPoll,
            pollWaitMillis: pollWaitMillis,
            apiVersion: apiVersion,
            unzip: unzip,
            containingFolder: containingFolder
    )
}
else {
    ant.sfBulkRetrieve(
            username: username,
            retrieveTarget: retrieveTarget,
            metadataType: metadataType,
            password: password,
            serverurl: serverUrl,
            batchSize: batchSize,
            maxPoll: maxPoll,
            pollWaitMillis: pollWaitMillis,
            apiVersion: apiVersion,
            unzip: unzip
    )
}
