/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.salesforce.SalesForceHelper

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

String password = props['password']
String username = props['username']
String serverUrl = props['serverUrl']
String recentValidationId = props['recentValidationId']
String sessionId = props['sessionId']
String maxPoll = props['maxPoll']?:"200"
String pollWaitMillis = props['pollWaitMillis']?:"10000"
String isRollback = "true"

//if isRollback is specified, set as specified value
if (props['isRollback']) {
    isRollback = String.valueOf(props['isRollback'])
}

if (username == "" && sessionId == "") {
    println ("[ERROR] Must provide a username and password or a sessionId.")
    System.exit(1)
}

def helper = new SalesForceHelper(props)
AntBuilder ant = helper.buildAnt()

println("[ACTION] Deploying recent validation '${recentValidationId}'...")

ant.taskdef name: "sfDeployRecentValidation", classname: "com.salesforce.ant.DeployRecentValidationTask"
ant.sfDeployRecentValidation(
        username: username,
        password: password,
        serverurl: serverUrl,
        sessionId: sessionId,
        rollbackOnError: isRollback,
        maxPoll: maxPoll,
        pollWaitMillis: pollWaitMillis,
        recentValidationId : recentValidationId
)
