/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.plugin.selenium.SeleniumHelper
import com.urbancode.air.AirPluginTool


def apTool = new AirPluginTool(this.args[0], this.args[1])
String result
int totalTime
int numTestTotal
int numTestPasses
int numTestFailures
int numCommandPasses
int numCommandFailures
int numCommandErrors
String seleniumVersion
String seleniumRevision

final def selenium = new SeleniumHelper(apTool.getStepProperties())

try {

    // Run the Selenium Test Suite
    selenium.runTest()

    // Look at results file and retrieve the pass/fail and all other numerical results
    (result, totalTime, numTestTotal, numTestPasses, numTestFailures, numCommandPasses, numCommandFailures,
        numCommandErrors, seleniumVersion, seleniumRevision ) = selenium.getResults()

} finally {
    apTool.setOutputProperty('testResultsFile', selenium.testResults)
    apTool.setOutputProperty('result', result?:"none")
    apTool.setOutputProperty('totalTime', totalTime.toString()?:"-1")
    apTool.setOutputProperty('numTestTotal', numTestTotal.toString()?:"-1")
    apTool.setOutputProperty('numTestPasses', numTestFailures.toString()?:"-1")
    apTool.setOutputProperty('numTestFailures', numTestFailures.toString()?:"-1")
    apTool.setOutputProperty('numCommandPasses', numCommandPasses.toString()?:"-1")
    apTool.setOutputProperty('numCommandFailures', numCommandFailures.toString()?:"-1")
    apTool.setOutputProperty('numCommandErrors', numCommandErrors.toString()?:"-1")
    apTool.setOutputProperty('seleniumVersion', seleniumVersion?:"none")
    apTool.setOutputProperty('seleniumRevision', seleniumRevision?:"none")
    apTool.setOutputProperties()
    selenium.printFile(selenium.testResults)
    selenium.printSummary(result, totalTime, numTestTotal, numTestPasses, numTestFailures,
        numCommandPasses, numCommandFailures, numCommandErrors, seleniumVersion, seleniumRevision )
}

// Confirm percentage of successes and failures is above threshold
if (!selenium.checkResults(numTestPasses, numTestFailures)) {
    // If threshold surpassed, fail.
    System.out.exit(1)
}
