/*
 * Decompiled with CFR 0.152.
 */
package java.com.urbancode.air;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.regex.Pattern;

public class AirPluginTool {
    public final boolean isWindows = Pattern.compile("(?i)windows").matcher(System.getProperty("os.name")).find();
    private final PrintStream out = System.out;
    private final PrintStream err = System.err;
    private final String inPropsFile;
    private final String outPropsFile;
    private final Properties outProps;

    public AirPluginTool(String inFile, String outFile) {
        this.inPropsFile = inFile;
        this.outPropsFile = outFile;
        this.outProps = new Properties();
    }

    public Properties getStepProperties() {
        Properties props = new Properties();
        try (FileInputStream inputPropsStream = new FileInputStream(this.inPropsFile);){
            props.load(inputPropsStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return props;
    }

    public void setOutputProperty(String name, String value) {
        this.outProps.setProperty(name, value);
    }

    public void setOutputProperties() {
        try (FileOutputStream outputPropsStream = new FileOutputStream(this.outPropsFile);){
            this.outProps.store(outputPropsStream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAuthToken() {
        String authToken = System.getenv("AUTH_TOKEN");
        return "{\"token\" : \"" + authToken + "\"}";
    }

    public String getAuthTokenUsername() {
        return "PasswordIsAuthToken";
    }

    public void storeOutputProperties() {
        this.setOutputProperties();
    }
}

