/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;

class PreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext oldContext) throws HttpException, IOException {
        HttpHost targetHost;
        CredentialsProvider credsProvider;
        Credentials creds;
        HttpClientContext context = HttpClientContext.adapt(oldContext);
        AuthState authState = context.getTargetAuthState();
        if (authState.getAuthScheme() == null && (creds = (credsProvider = context.getCredentialsProvider()).getCredentials(new AuthScope((targetHost = context.getTargetHost()).getHostName(), targetHost.getPort()))) != null) {
            authState.setState(AuthProtocolState.CHALLENGED);
            authState.update(new BasicScheme(), creds);
        }
    }
}

